/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.bst;

import java.util.Stack;
import net.sf.jabref.AuthorList;
import net.sf.jabref.bst.BibtexNameFormatter;
import net.sf.jabref.bst.VM;
import net.sf.jabref.bst.VMException;

public class FormatNameFunction
implements VM.BstFunction {
    VM vm;

    public FormatNameFunction(VM vM) {
        this.vm = vM;
    }

    public void execute(VM.BstEntry bstEntry) {
        Stack stack = this.vm.getStack();
        if (stack.size() < 3) {
            throw new VMException("Not enough operands on stack for operation format.name$");
        }
        Object e = stack.pop();
        Object e2 = stack.pop();
        Object e3 = stack.pop();
        if (!(e instanceof String || e2 instanceof Integer || e3 instanceof String)) {
            stack.push("");
            return;
        }
        String string = (String)e;
        Integer n = (Integer)e2;
        String string2 = (String)e3;
        if (string2 != null) {
            AuthorList authorList = AuthorList.getAuthorList(string2);
            if (n > authorList.size()) {
                throw new VMException("Author Out of Bounds. Number " + n + " invalid for " + string2);
            }
            AuthorList.Author author = authorList.getAuthor(n - 1);
            stack.push(BibtexNameFormatter.formatName(author, string, this.vm));
        } else {
            stack.push("");
        }
    }
}

