/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.bst;

import net.sf.jabref.bst.BibtexCaseChanger;
import net.sf.jabref.bst.Warn;

public class BibtexPurify {
    public static String purify(String string, Warn warn) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isWhitespace(c) || c == '-' || c == '~') {
                stringBuffer.append(' ');
            } else if (Character.isLetterOrDigit(c)) {
                stringBuffer.append(c);
            } else if (c == '{') {
                if (++n3 == 1 && n2 + 1 < n && cArray[n2 + 1] == '\\') {
                    ++n2;
                    while (n2 < n && n3 > 0) {
                        String string2;
                        if ((string2 = BibtexCaseChanger.findSpecialChar(cArray, ++n2)) != null) {
                            stringBuffer.append(string2);
                        }
                        while (n2 < n && Character.isLetter(cArray[n2])) {
                            ++n2;
                        }
                        while (n2 < n && n3 > 0 && (c = cArray[n2]) != '\\') {
                            if (Character.isLetterOrDigit(c)) {
                                stringBuffer.append(c);
                            } else if (c == '}') {
                                --n3;
                            } else if (c == '{') {
                                ++n3;
                            }
                            ++n2;
                        }
                    }
                    continue;
                }
            } else if (c == '}') {
                if (n3 > 0) {
                    --n3;
                } else if (warn != null) {
                    warn.warn("Unbalanced brace in string for purify$: " + string);
                }
            }
            ++n2;
        }
        if (n3 != 0 && warn != null) {
            warn.warn("Unbalanced brace in string for purify$: " + string);
        }
        return stringBuffer.toString();
    }
}

