/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.about;

import java.awt.Color;
import java.awt.image.RGBImageFilter;

class HighlightFilter
extends RGBImageFilter {
    boolean brighter;
    int percent;
    private int middleX;
    private int middleY;
    private int dimX;
    private int dimY;
    private int distance = 0;
    private int startSize = 10;
    private int white = Color.white.getRGB();
    private int black = Color.black.getRGB();

    public HighlightFilter(boolean bl, int n) {
        this.brighter = bl;
        this.percent = n;
        this.canFilterIndexColorModel = true;
    }

    public void setMiddle(int n, int n2) {
        this.middleX = n / 2;
        this.middleY = n2 / 2;
        this.dimX = n;
        this.dimY = n2;
        this.distance = this.startSize;
    }

    public final void nextStep() {
        this.distance = (int)((double)this.distance + ((double)this.distance / 1.5 + 1.0));
    }

    public boolean isReady() {
        boolean bl = false;
        if (this.dimX < this.distance && this.dimY < this.distance) {
            bl = true;
        }
        return bl;
    }

    public final int filterRGB(int n, int n2, int n3) {
        int n4 = n3;
        int n5 = n - this.middleX;
        int n6 = n2 - this.middleY;
        int n7 = (int)Math.sqrt(Math.abs(2 * n5 * n6));
        if (n7 < this.distance && n != this.middleX && n2 != this.middleY || (n == this.middleX || n2 == this.middleY) && this.distance > 30) {
            n4 = this.white;
        } else if (n7 == this.distance && n7 > 20) {
            n4 = this.black;
        }
        return n4;
    }
}

