/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.net.URLDownload;

public class UrlDragDrop
implements DropTargetListener {
    private static Logger logger = Logger.getLogger(UrlDragDrop.class.getName());
    private FieldEditor feditor;
    private EntryEditor editor;
    private JabRefFrame frame;

    public UrlDragDrop(EntryEditor entryEditor, JabRefFrame jabRefFrame, FieldEditor fieldEditor) {
        this.editor = entryEditor;
        this.feditor = fieldEditor;
        this.frame = jabRefFrame;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        dropTargetDropEvent.acceptDrop(3);
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.WARNING, "Class not found for DnD... should not happen", classNotFoundException);
        }
        try {
            URL uRL = (URL)transferable.getTransferData(dataFlavor);
            JOptionChoice jOptionChoice = (JOptionChoice)JOptionPane.showInputDialog(this.editor, "", Globals.lang("Select action"), 3, null, new JOptionChoice[]{new JOptionChoice(Globals.lang("Insert URL"), 0), new JOptionChoice(Globals.lang("Download file"), 1)}, new JOptionChoice(Globals.lang("Insert URL"), 0));
            switch (jOptionChoice.getId()) {
                case 0: {
                    this.feditor.setText(uRL.toString());
                    this.editor.updateField(this.feditor);
                    break;
                }
                case 1: {
                    try {
                        File file = new File(new File(Globals.prefs.get("pdfDirectory")), this.editor.getEntry().getField("bibtexkey") + ".pdf");
                        URLDownload uRLDownload = new URLDownload(this.editor, uRL, file);
                        this.frame.output(Globals.lang("Downloading..."));
                        uRLDownload.download();
                        this.frame.output(Globals.lang("Download completed"));
                        this.feditor.setText(file.toURL().toString());
                        this.editor.updateField(this.feditor);
                        break;
                    }
                    catch (IOException iOException) {
                        logger.log(Level.SEVERE, "Error while downloading file", iOException);
                        JOptionPane.showMessageDialog(this.editor, Globals.lang("File download"), Globals.lang("Error while downloading file:" + iOException.getMessage()), 0);
                    }
                }
            }
            return;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "!should not happen!", iOException);
        }
        try {
            List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            if (list.size() > 1) {
                JOptionPane.showMessageDialog(this.editor, Globals.lang("Only one item is supported"), Globals.lang("Drag and Drop Error"), 0);
                return;
            }
            File file = (File)list.get(0);
            this.feditor.setText(file.toURI().toURL().toString());
            this.editor.updateField(this.feditor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            JOptionPane.showMessageDialog(this.editor, Globals.lang("Operation not supported"), Globals.lang("Drag and Drop Error"), 0);
            logger.log(Level.WARNING, "Transfer exception", unsupportedFlavorException);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Transfer exception", iOException);
        }
    }

    private static class JOptionChoice {
        private String label;
        private int id;

        public JOptionChoice(String string, int n) {
            this.label = string;
            this.id = n;
        }

        public String toString() {
            return this.label;
        }

        public int getId() {
            return this.id;
        }
    }
}

