/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.text.JTextComponent;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldTextArea;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.undo.UndoablePreambleChange;

public class PreambleEditor
extends JDialog {
    BibtexDatabase base;
    BasePanel panel;
    JabRefFrame baseFrame;
    JabRefPreferences prefs;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JLabel lab;
    Container conPane = this.getContentPane();
    JPanel pan = new JPanel();
    FieldEditor ed;
    StoreFieldAction storeFieldAction = new StoreFieldAction();
    UndoAction undoAction = new UndoAction();
    RedoAction redoAction = new RedoAction();
    CloseAction closeAction = new CloseAction();

    public PreambleEditor(JabRefFrame jabRefFrame, BasePanel basePanel, BibtexDatabase bibtexDatabase, JabRefPreferences jabRefPreferences) {
        super(jabRefFrame);
        this.baseFrame = jabRefFrame;
        this.panel = basePanel;
        this.base = bibtexDatabase;
        this.prefs = jabRefPreferences;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PreambleEditor.this.closeAction.actionPerformed(null);
            }

            public void windowOpened(WindowEvent windowEvent) {
                PreambleEditor.this.ed.requestFocus();
            }
        });
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            protected boolean accept(Component component) {
                return super.accept(component) && component instanceof FieldEditor;
            }
        });
        int n = (int)(2.0 * (double)GUIGlobals.FORM_HEIGHT[jabRefPreferences.getInt("entryTypeFormHeightFactor")]);
        this.setSize(GUIGlobals.FORM_WIDTH[jabRefPreferences.getInt("entryTypeFormWidth")], n);
        this.pan.setLayout(this.gbl);
        this.con.fill = 1;
        this.con.weighty = 1.0;
        this.con.insets = new Insets(10, 5, 10, 5);
        String string = bibtexDatabase.getPreamble();
        this.ed = new FieldTextArea(Globals.lang("Preamble"), string != null ? string : "");
        this.setupJTextComponent((FieldTextArea)this.ed);
        this.gbl.setConstraints(this.ed.getLabel(), this.con);
        this.pan.add(this.ed.getLabel());
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.ed.getPane(), this.con);
        this.pan.add(this.ed.getPane());
        this.conPane.add((Component)this.pan, "Center");
        this.setTitle(Globals.lang("Edit preamble"));
    }

    private void setupJTextComponent(JTextComponent jTextComponent) {
        jTextComponent.getInputMap().put(this.prefs.getKey("Close preamble editor"), "close");
        jTextComponent.getActionMap().put("close", this.closeAction);
        jTextComponent.getInputMap().put(this.prefs.getKey("Preamble editor, store changes"), "store");
        jTextComponent.getActionMap().put("store", this.storeFieldAction);
        jTextComponent.getInputMap().put(this.prefs.getKey("Close preamble editor"), "close");
        jTextComponent.getActionMap().put("close", this.closeAction);
        jTextComponent.getInputMap().put(this.prefs.getKey("Undo"), "undo");
        jTextComponent.getActionMap().put("undo", this.undoAction);
        jTextComponent.getInputMap().put(this.prefs.getKey("Redo"), "redo");
        jTextComponent.getActionMap().put("redo", this.redoAction);
        jTextComponent.addFocusListener(new FieldListener());
    }

    public void updatePreamble() {
        this.ed.setText(this.base.getPreamble());
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Globals.lang("Close window"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PreambleEditor.this.storeFieldAction.actionPerformed(null);
            PreambleEditor.this.panel.preambleEditorClosing();
            PreambleEditor.this.dispose();
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Undo", GUIGlobals.getImage("redo"));
            this.putValue("ShortDescription", "Redo");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                PreambleEditor.this.panel.runCommand("redo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo", GUIGlobals.getImage("undo"));
            this.putValue("ShortDescription", "Undo");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                PreambleEditor.this.panel.runCommand("undo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class StoreFieldAction
    extends AbstractAction {
        public StoreFieldAction() {
            super("Store field value");
            this.putValue("ShortDescription", "Store field value");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            if (PreambleEditor.this.ed.getText().length() > 0) {
                string = PreambleEditor.this.ed.getText();
            }
            boolean bl = string == null ? PreambleEditor.this.base.getPreamble() != null : PreambleEditor.this.base.getPreamble() == null || !string.equals(PreambleEditor.this.base.getPreamble());
            if (bl) {
                PreambleEditor.this.panel.undoManager.addEdit(new UndoablePreambleChange(PreambleEditor.this.base, PreambleEditor.this.panel, PreambleEditor.this.base.getPreamble(), string));
                PreambleEditor.this.base.setPreamble(string);
                if (string != null && string.length() > 0) {
                    PreambleEditor.this.ed.setLabelColor(GUIGlobals.validFieldColor);
                    PreambleEditor.this.ed.setBackground(GUIGlobals.validFieldBackground);
                } else {
                    PreambleEditor.this.ed.setLabelColor(GUIGlobals.nullFieldColor);
                    PreambleEditor.this.ed.setBackground(GUIGlobals.validFieldBackground);
                }
                PreambleEditor.this.panel.markBaseChanged();
            }
        }
    }

    class FieldListener
    extends FocusAdapter {
        FieldListener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                PreambleEditor.this.storeFieldAction.actionPerformed(new ActionEvent(focusEvent.getSource(), 0, ""));
            }
        }
    }
}

