/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.VersionHandling;

public class MetaData {
    private HashMap metaData = new HashMap();
    private StringReader data;
    private GroupTreeNode groupsRoot = null;
    private File file = null;

    public MetaData(HashMap hashMap, BibtexDatabase bibtexDatabase) {
        boolean bl = false;
        Vector<String> vector = null;
        Vector<String> vector2 = null;
        int n = 0;
        if (hashMap != null) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.data = new StringReader((String)hashMap.get(string));
                Vector<String> vector3 = new Vector<String>();
                try {
                    String string2;
                    while ((string2 = this.getNextUnit(this.data)) != null) {
                        vector3.add(string2);
                    }
                }
                catch (IOException iOException) {
                    System.err.println("Weird error while parsing meta data.");
                }
                if (string.equals("groupsversion")) {
                    if (vector3.size() < 1) continue;
                    n = Integer.parseInt(vector3.firstElement().toString());
                    continue;
                }
                if (string.equals("groupstree")) {
                    bl = true;
                    vector2 = vector3;
                    continue;
                }
                if (string.equals("groups")) {
                    vector = vector3;
                    continue;
                }
                this.putData(string, vector3);
            }
        }
        if (bl) {
            this.putGroups(vector2, bibtexDatabase, n);
        }
        if (!bl && vector != null) {
            this.groupsRoot = VersionHandling.importFlatGroups(vector);
        }
    }

    public MetaData() {
    }

    public void initializeNewDatabase() {
        this.metaData.put("selector_keywords", new Vector());
        this.metaData.put("selector_author", new Vector());
        this.metaData.put("selector_journal", new Vector());
        this.metaData.put("selector_publisher", new Vector());
    }

    public Iterator iterator() {
        return this.metaData.keySet().iterator();
    }

    public Vector getData(String string) {
        return (Vector)this.metaData.get(string);
    }

    public void remove(String string) {
        this.metaData.remove(string);
    }

    public void putData(String string, Vector vector) {
        this.metaData.put(string, vector);
    }

    public String getFileDirectory(String string) {
        String string2;
        String string3 = string + "Directory";
        Vector vector = this.getData(string3);
        if (vector != null && vector.size() > 0) {
            String string4;
            string2 = (String)vector.get(0);
            if (!new File(string2).isAbsolute() && this.file != null && new File(string4 = this.file.getParent() + System.getProperty("file.separator") + string2).exists()) {
                string2 = string4;
            }
        } else {
            string2 = Globals.prefs.get(string3);
        }
        return string2;
    }

    private void putGroups(Vector vector, BibtexDatabase bibtexDatabase, int n) {
        try {
            this.groupsRoot = VersionHandling.importGroups(vector, bibtexDatabase, n);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public GroupTreeNode getGroups() {
        return this.groupsRoot;
    }

    public void setGroups(GroupTreeNode groupTreeNode) {
        this.groupsRoot = groupTreeNode;
    }

    public void writeMetaData(Writer writer) throws IOException {
        StringBuffer stringBuffer;
        Object object;
        Object object2 = this.metaData.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            stringBuffer = new StringBuffer();
            Vector vector = (Vector)this.metaData.get(object);
            if (vector.size() >= 0) {
                stringBuffer.append("@comment{").append(GUIGlobals.META_FLAG).append((String)object).append(":");
                for (int i = 0; i < vector.size(); ++i) {
                    stringBuffer.append(Util.quote((String)vector.elementAt(i), ";", '\\')).append(";");
                }
                stringBuffer.append("}");
                stringBuffer.append(Globals.NEWLINE);
                stringBuffer.append(Globals.NEWLINE);
            }
            this.wrapStringBuffer(stringBuffer, Globals.METADATA_LINE_LENGTH);
            writer.write(stringBuffer.toString());
        }
        if (this.groupsRoot != null && this.groupsRoot.getChildCount() > 0) {
            object2 = new StringBuffer();
            ((StringBuffer)object2).append("@comment{").append(GUIGlobals.META_FLAG).append("groupsversion:");
            ((StringBuffer)object2).append("3;");
            ((StringBuffer)object2).append("}");
            ((StringBuffer)object2).append(Globals.NEWLINE);
            ((StringBuffer)object2).append(Globals.NEWLINE);
            writer.write(((StringBuffer)object2).toString());
            object2 = new StringBuffer();
            ((StringBuffer)object2).append("@comment{").append(GUIGlobals.META_FLAG).append("groupstree:");
            ((StringBuffer)object2).append(Globals.NEWLINE);
            object = new StringTokenizer(this.groupsRoot.getTreeAsString(), Globals.NEWLINE);
            while (((StringTokenizer)object).hasMoreTokens()) {
                stringBuffer = new StringBuffer(Util.quote(((StringTokenizer)object).nextToken(), ";", '\\') + ";");
                this.wrapStringBuffer(stringBuffer, Globals.METADATA_LINE_LENGTH);
                ((StringBuffer)object2).append(stringBuffer);
                ((StringBuffer)object2).append(Globals.NEWLINE);
            }
            ((StringBuffer)object2).append("}");
            ((StringBuffer)object2).append(Globals.NEWLINE);
            ((StringBuffer)object2).append(Globals.NEWLINE);
            writer.write(((StringBuffer)object2).toString());
        }
    }

    private void wrapStringBuffer(StringBuffer stringBuffer, int n) {
        for (int i = n; i < stringBuffer.length(); i += n + Globals.NEWLINE_LENGTH) {
            stringBuffer.insert(i, Globals.NEWLINE);
        }
    }

    private String getNextUnit(Reader reader) throws IOException {
        int n;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = reader.read()) != -1) {
            if (bl) {
                stringBuffer.append((char)n);
                bl = false;
                continue;
            }
            if (n == 92) {
                bl = true;
                continue;
            }
            if (n == 59) break;
            stringBuffer.append((char)n);
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

