/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFileChooser;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;

class ExternalProgramsTab
extends JPanel
implements PrefsTab {
    JabRefPreferences _prefs;
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints con = new GridBagConstraints();
    JTextField pdf;
    JTextField ps;
    JTextField html;
    JTextField lyx;

    public ExternalProgramsTab(JabRefPreferences jabRefPreferences) {
        this._prefs = jabRefPreferences;
        this.pdf = new JTextField(this._prefs.get("pdfviewer"), 30);
        this.ps = new JTextField(this._prefs.get("psviewer"), 30);
        this.html = new JTextField(this._prefs.get("htmlviewer"), 30);
        this.lyx = new JTextField(this._prefs.get("lyxpipe"), 30);
        this.setLayout(this.gbl);
        this.con.weightx = 0.0;
        this.con.insets = new Insets(10, 10, 10, 10);
        this.con.fill = 2;
        JLabel jLabel = new JLabel(Globals.lang("Path to PDF viewer") + ":");
        this.gbl.setConstraints(jLabel, this.con);
        this.add(jLabel);
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.pdf, this.con);
        this.add(this.pdf);
        this.con.weightx = 0.0;
        this.con.gridwidth = 0;
        JButton jButton = new JButton(Globals.lang("Browse"));
        jButton.addActionListener(new BrowseAction(this.pdf));
        this.gbl.setConstraints(jButton, this.con);
        this.add(jButton);
        this.con.gridwidth = 1;
        this.con.fill = 2;
        jLabel = new JLabel(Globals.lang("Path to PS viewer") + ":");
        this.gbl.setConstraints(jLabel, this.con);
        this.add(jLabel);
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.ps, this.con);
        this.add(this.ps);
        this.con.weightx = 0.0;
        this.con.gridwidth = 0;
        jButton = new JButton(Globals.lang("Browse"));
        jButton.addActionListener(new BrowseAction(this.ps));
        this.gbl.setConstraints(jButton, this.con);
        this.add(jButton);
        this.con.gridwidth = 1;
        jLabel = new JLabel(Globals.lang("Path to HTML viewer") + ":");
        this.gbl.setConstraints(jLabel, this.con);
        this.add(jLabel);
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.html, this.con);
        this.add(this.html);
        this.con.gridwidth = 0;
        this.con.weightx = 0.0;
        jButton = new JButton(Globals.lang("Browse"));
        jButton.addActionListener(new BrowseAction(this.html));
        this.gbl.setConstraints(jButton, this.con);
        this.add(jButton);
        this.con.gridwidth = 1;
        this.con.fill = 2;
        jLabel = new JLabel(Globals.lang("Path to LyX pipe") + ":");
        this.gbl.setConstraints(jLabel, this.con);
        this.add(jLabel);
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.lyx, this.con);
        this.add(this.lyx);
        this.con.weightx = 0.0;
        jButton = new JButton(Globals.lang("Browse"));
        jButton.addActionListener(new BrowseAction(this.lyx));
        this.gbl.setConstraints(jButton, this.con);
        this.add(jButton);
    }

    public void setValues() {
    }

    public void storeSettings() {
        this._prefs.put("pdfviewer", this.pdf.getText());
        this._prefs.put("psviewer", this.ps.getText());
        this._prefs.put("htmlviewer", this.html.getText());
        this._prefs.put("lyxpipe", this.lyx.getText());
    }

    public boolean readyToClose() {
        return true;
    }

    public String getTabName() {
        return Globals.lang("External programs");
    }

    class BrowseAction
    extends AbstractAction {
        JTextField comp;

        public BrowseAction(JTextField jTextField) {
            super(Globals.lang("Browse"));
            this.comp = jTextField;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JabRefFileChooser jabRefFileChooser = new JabRefFileChooser(new File(this.comp.getText()));
            int n = jabRefFileChooser.showOpenDialog(null);
            if (n == 0) {
                File file = jabRefFileChooser.getSelectedFile();
                this.comp.setText(file.getPath());
            }
        }
    }
}

