/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.DatabaseChangeEvent;
import net.sf.jabref.DatabaseChangeListener;

public class EntrySorter
implements DatabaseChangeListener {
    final ArrayList set = new ArrayList();
    Comparator comp;
    String[] idArray;
    BibtexEntry[] entryArray;
    private boolean outdated = false;
    private boolean changed = false;

    public EntrySorter(Map map, Comparator comparator) {
        this.comp = comparator;
        Set set = map.keySet();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.set.add(map.get(iterator.next()));
            }
            this.changed = true;
            this.index();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index() {
        ArrayList arrayList = this.set;
        synchronized (arrayList) {
            if (this.changed) {
                Collections.sort(this.set, this.comp);
                this.changed = false;
            }
            int n = this.set.size();
            this.idArray = new String[n];
            this.entryArray = new BibtexEntry[n];
            int n2 = 0;
            Iterator iterator = this.set.iterator();
            while (iterator.hasNext()) {
                BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
                this.idArray[n2] = bibtexEntry.getId();
                this.entryArray[n2] = bibtexEntry;
                ++n2;
            }
        }
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIdAt(int n) {
        ArrayList arrayList = this.set;
        synchronized (arrayList) {
            return this.idArray[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BibtexEntry getEntryAt(int n) {
        ArrayList arrayList = this.set;
        synchronized (arrayList) {
            return this.entryArray[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntryCount() {
        ArrayList arrayList = this.set;
        synchronized (arrayList) {
            if (this.entryArray != null) {
                return this.entryArray.length;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void databaseChanged(DatabaseChangeEvent databaseChangeEvent) {
        ArrayList arrayList = this.set;
        synchronized (arrayList) {
            if (databaseChangeEvent.getType() == DatabaseChangeEvent.ADDED_ENTRY) {
                int n = -Collections.binarySearch(this.set, databaseChangeEvent.getEntry(), this.comp) - 1;
                this.set.add(n, databaseChangeEvent.getEntry());
            } else if (databaseChangeEvent.getType() == DatabaseChangeEvent.REMOVED_ENTRY) {
                this.set.remove(databaseChangeEvent.getEntry());
                this.changed = true;
            } else if (databaseChangeEvent.getType() == DatabaseChangeEvent.CHANGED_ENTRY) {
                int n = Collections.binarySearch(this.set, databaseChangeEvent.getEntry(), this.comp);
                int n2 = this.set.indexOf(databaseChangeEvent.getEntry());
                if (n < 0) {
                    this.set.remove(n2);
                    this.set.add(-n - 1, databaseChangeEvent.getEntry());
                }
            }
        }
    }

    private void addEntry(BibtexEntry bibtexEntry) {
        int n = -Collections.binarySearch(this.set, bibtexEntry, this.comp) - 1;
        this.set.add(n, bibtexEntry);
    }
}

