/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Dialog;
import java.awt.Window;
import java.util.Vector;
import javax.swing.undo.CompoundEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.DuplicateResolverDialog;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableRemoveEntry;

public class DuplicateSearch
extends Thread {
    BasePanel panel;
    BibtexEntry[] bes;
    final Vector duplicates = new Vector();

    public DuplicateSearch(BasePanel basePanel) {
        this.panel = basePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        CompoundEdit compoundEdit = null;
        int n = 0;
        this.panel.output(Globals.lang("Searching for duplicates..."));
        Object[] objectArray = this.panel.database.getKeySet().toArray();
        if (objectArray == null) return;
        if (objectArray.length < 2) {
            return;
        }
        this.bes = new BibtexEntry[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.bes[i] = this.panel.database.getEntryById((String)objectArray[i]);
        }
        SearcherThread searcherThread = new SearcherThread();
        searcherThread.setPriority(1);
        searcherThread.start();
        int n2 = 0;
        Window window = null;
        while (!searcherThread.finished() || n2 < this.duplicates.size()) {
            BibtexEntry[] bibtexEntryArray;
            if (n2 >= this.duplicates.size()) {
                bibtexEntryArray = this.duplicates;
                // MONITORENTER : this.duplicates
                try {
                    this.duplicates.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
            bibtexEntryArray = (BibtexEntry[])this.duplicates.get(n2);
            ++n2;
            if (this.panel.database.getEntryById(bibtexEntryArray[0].getId()) == null || this.panel.database.getEntryById(bibtexEntryArray[1].getId()) == null) continue;
            window = new DuplicateResolverDialog(this.panel.frame, bibtexEntryArray[0], bibtexEntryArray[1], 1);
            ((Dialog)window).setVisible(true);
            ++n;
            int n3 = ((DuplicateResolverDialog)window).getSelected();
            if (n3 == 1) {
                if (compoundEdit == null) {
                    compoundEdit = new NamedCompound(Globals.lang("duplicate removal"));
                }
                this.panel.database.removeEntry(bibtexEntryArray[1].getId());
                this.panel.markBaseChanged();
                compoundEdit.addEdit(new UndoableRemoveEntry(this.panel.database, bibtexEntryArray[1], this.panel));
            } else if (n3 == 2) {
                if (compoundEdit == null) {
                    compoundEdit = new NamedCompound(Globals.lang("duplicate removal"));
                }
                this.panel.database.removeEntry(bibtexEntryArray[0].getId());
                this.panel.markBaseChanged();
                compoundEdit.addEdit(new UndoableRemoveEntry(this.panel.database, bibtexEntryArray[0], this.panel));
            } else if (n3 == 5) {
                searcherThread.setFinished();
                n2 = Integer.MAX_VALUE;
                --n;
            }
            window.dispose();
        }
        if (window != null) {
            window.dispose();
        }
        this.panel.output(Globals.lang("Duplicate pairs found") + ": " + this.duplicates.size() + " " + Globals.lang("pairs processed") + ": " + n);
        if (compoundEdit == null) return;
        compoundEdit.end();
        this.panel.undoManager.addEdit(compoundEdit);
    }

    class SearcherThread
    extends Thread {
        private boolean finished = false;

        SearcherThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            for (int i = 0; i < DuplicateSearch.this.bes.length - 1 && !this.finished; ++i) {
                for (int j = i + 1; j < DuplicateSearch.this.bes.length && !this.finished; ++j) {
                    boolean bl = Util.isDuplicate(DuplicateSearch.this.bes[i], DuplicateSearch.this.bes[j], Globals.duplicateThreshold);
                    if (!bl) continue;
                    Vector vector = DuplicateSearch.this.duplicates;
                    synchronized (vector) {
                        DuplicateSearch.this.duplicates.add(new BibtexEntry[]{DuplicateSearch.this.bes[i], DuplicateSearch.this.bes[j]});
                        DuplicateSearch.this.duplicates.notifyAll();
                        continue;
                    }
                }
            }
            this.finished = true;
            Vector vector = DuplicateSearch.this.duplicates;
            synchronized (vector) {
                DuplicateSearch.this.duplicates.notifyAll();
            }
        }

        public boolean finished() {
            return this.finished;
        }

        public void setFinished() {
            this.finished = true;
        }
    }
}

