/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;

public class ContentSelectorDialog2
extends JDialog {
    ActionListener wordEditFieldListener = null;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JPanel fieldPan = new JPanel();
    JPanel wordPan = new JPanel();
    JPanel buttonPan = new JPanel();
    JPanel fieldNamePan = new JPanel();
    JPanel wordEditPan = new JPanel();
    final String WORD_EMPTY_TEXT = Globals.lang("<no field>");
    final String WORD_FIRSTLINE_TEXT = Globals.lang("<select word>");
    final String FIELD_FIRST_LINE = Globals.lang("<field name>");
    MetaData metaData;
    String currentField = null;
    TreeSet fieldSet;
    TreeSet wordSet;
    JabRefFrame frame;
    BasePanel panel;
    JButton help = new JButton(Globals.lang("Help"));
    JButton newField = new JButton(Globals.lang("New"));
    JButton removeField = new JButton(Globals.lang("Remove"));
    JButton newWord = new JButton(Globals.lang("New"));
    JButton removeWord = new JButton(Globals.lang("Remove"));
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    JButton apply = new JButton(Globals.lang("Apply"));
    DefaultListModel fieldListModel = new DefaultListModel();
    DefaultListModel wordListModel = new DefaultListModel();
    JList fieldList = new JList(this.fieldListModel);
    JList wordList = new JList(this.wordListModel);
    JTextField fieldNameField = new JTextField("", 20);
    JTextField wordEditField = new JTextField("", 20);
    JScrollPane fPane = new JScrollPane(this.fieldList);
    JScrollPane wPane = new JScrollPane(this.wordList);
    HashMap wordListModels = new HashMap();
    ArrayList removedFields = new ArrayList();

    public ContentSelectorDialog2(Frame frame, JabRefFrame jabRefFrame, BasePanel basePanel, boolean bl, MetaData metaData, String string) {
        super(frame, Globals.lang("Setup selectors"), bl);
        this.metaData = metaData;
        this.frame = jabRefFrame;
        this.panel = basePanel;
        this.currentField = string;
        this.doInit();
    }

    public ContentSelectorDialog2(Dialog dialog, JabRefFrame jabRefFrame, BasePanel basePanel, boolean bl, MetaData metaData, String string) {
        super(dialog, Globals.lang("Setup selectors"), bl);
        this.metaData = metaData;
        this.frame = jabRefFrame;
        this.panel = basePanel;
        this.currentField = string;
        this.doInit();
    }

    private void doInit() {
        this.initLayout();
        this.setupFieldSelector();
        this.setupWordSelector();
        this.setupActions();
        int n = this.fieldListModel.indexOf(this.currentField);
        if (n >= 0) {
            this.fieldList.setSelectedIndex(n);
        }
        this.pack();
    }

    private void setupActions() {
        this.wordList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ContentSelectorDialog2.this.wordEditField.setText((String)ContentSelectorDialog2.this.wordList.getSelectedValue());
                ContentSelectorDialog2.this.wordEditField.selectAll();
                new FocusRequester(ContentSelectorDialog2.this.wordEditField);
            }
        });
        this.newWord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentSelectorDialog2.this.newWordAction();
            }
        });
        this.wordEditFieldListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ContentSelectorDialog2.this.wordList.getSelectedIndex();
                String string = (String)ContentSelectorDialog2.this.wordList.getSelectedValue();
                String string2 = ContentSelectorDialog2.this.wordEditField.getText();
                if (string2.equals("") || string2.equals(string)) {
                    return;
                }
                int n2 = ContentSelectorDialog2.this.findPos(ContentSelectorDialog2.this.wordListModel, string2);
                if (n >= 0) {
                    ContentSelectorDialog2.this.wordListModel.remove(n);
                    ContentSelectorDialog2.this.wordListModel.add(n2 <= n ? n2 : n2 - 1, string2);
                } else {
                    ContentSelectorDialog2.this.wordListModel.add(n2, string2);
                }
                ContentSelectorDialog2.this.wordEditField.selectAll();
            }
        };
        this.wordEditField.addActionListener(this.wordEditFieldListener);
        this.removeWord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ContentSelectorDialog2.this.wordList.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                ContentSelectorDialog2.this.wordListModel.remove(n);
                ContentSelectorDialog2.this.wordEditField.setText("");
                if (ContentSelectorDialog2.this.wordListModel.size() > 0) {
                    ContentSelectorDialog2.this.wordList.setSelectedIndex(Math.min(n, ContentSelectorDialog2.this.wordListModel.size() - 1));
                }
            }
        });
        this.fieldList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ContentSelectorDialog2.this.currentField = (String)ContentSelectorDialog2.this.fieldList.getSelectedValue();
                ContentSelectorDialog2.this.fieldNameField.setText("");
                ContentSelectorDialog2.this.setupWordSelector();
            }
        });
        this.newField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentSelectorDialog2.this.fieldListModel.add(0, ContentSelectorDialog2.this.FIELD_FIRST_LINE);
                ContentSelectorDialog2.this.fieldList.setSelectedIndex(0);
                ContentSelectorDialog2.this.fPane.getVerticalScrollBar().setValue(0);
                ContentSelectorDialog2.this.fieldNameField.setEnabled(true);
                ContentSelectorDialog2.this.fieldNameField.setText(ContentSelectorDialog2.this.currentField);
                ContentSelectorDialog2.this.fieldNameField.selectAll();
                new FocusRequester(ContentSelectorDialog2.this.fieldNameField);
            }
        });
        this.fieldNameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentSelectorDialog2.this.fieldNameField.transferFocus();
            }
        });
        this.fieldNameField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                String string = ContentSelectorDialog2.this.fieldNameField.getText();
                ContentSelectorDialog2.this.fieldNameField.setText("");
                ContentSelectorDialog2.this.fieldNameField.setEnabled(false);
                if (!ContentSelectorDialog2.this.FIELD_FIRST_LINE.equals(string) && !"".equals(string)) {
                    int n = ContentSelectorDialog2.this.findPos(ContentSelectorDialog2.this.fieldListModel, string);
                    ContentSelectorDialog2.this.fieldListModel.remove(0);
                    ContentSelectorDialog2.this.fieldListModel.add(Math.max(0, n - 1), string);
                    ContentSelectorDialog2.this.fieldList.setSelectedIndex(n);
                    ContentSelectorDialog2.this.currentField = string;
                    ContentSelectorDialog2.this.setupWordSelector();
                    ContentSelectorDialog2.this.newWordAction();
                }
            }
        });
        this.removeField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ContentSelectorDialog2.this.fieldList.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                String string = (String)ContentSelectorDialog2.this.fieldListModel.get(n);
                ContentSelectorDialog2.this.removedFields.add(string);
                ContentSelectorDialog2.this.fieldListModel.remove(n);
                ContentSelectorDialog2.this.wordListModels.remove(string);
                ContentSelectorDialog2.this.fieldNameField.setText("");
                if (ContentSelectorDialog2.this.fieldListModel.size() > 0) {
                    ContentSelectorDialog2.this.fieldList.setSelectedIndex(Math.min(n, ContentSelectorDialog2.this.wordListModel.size() - 1));
                }
            }
        });
        this.help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentSelectorDialog2.this.frame.helpDiag.showPage(GUIGlobals.contentSelectorHelp);
            }
        });
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentSelectorDialog2.this.applyChanges();
                ContentSelectorDialog2.this.dispose();
            }
        });
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ContentSelectorDialog2.this.wordEditField.getText().equals("")) {
                    ContentSelectorDialog2.this.wordEditFieldListener.actionPerformed(null);
                }
                ContentSelectorDialog2.this.applyChanges();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentSelectorDialog2.this.dispose();
            }
        });
    }

    private void newWordAction() {
        if (this.wordListModel.size() == 0 || !this.wordListModel.get(0).equals(this.WORD_FIRSTLINE_TEXT)) {
            this.wordListModel.add(0, this.WORD_FIRSTLINE_TEXT);
        }
        this.wordList.setSelectedIndex(0);
        this.wPane.getVerticalScrollBar().setValue(0);
    }

    private void applyChanges() {
        String string;
        boolean bl = false;
        Iterator<Object> iterator = this.removedFields.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.metaData.remove("selector_" + string);
            bl = true;
        }
        iterator = this.wordListModels.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (string == null || this.FIELD_FIRST_LINE.equals(string)) continue;
            DefaultListModel defaultListModel = (DefaultListModel)this.wordListModels.get(string);
            if (defaultListModel.size() > 0) {
                for (int i = 0; i < defaultListModel.size() && ((String)defaultListModel.get(i)).equals(this.WORD_FIRSTLINE_TEXT); ++i) {
                }
            }
            Vector<String> vector = this.metaData.getData("selector_" + string);
            boolean bl2 = false;
            if (vector == null) {
                bl2 = true;
                vector = new Vector<String>();
                bl = true;
            } else {
                vector.clear();
            }
            for (int i = i; i < defaultListModel.size(); ++i) {
                String string2 = (String)defaultListModel.get(i);
                vector.add(string2);
            }
            if (!bl2) continue;
            this.metaData.putData("selector_" + string, vector);
        }
        this.panel.markNonUndoableBaseChanged();
        if (!bl) {
            this.panel.updateAllContentSelectors();
        } else {
            this.panel.rebuildAllEntryEditors();
        }
    }

    private void setupFieldSelector() {
        this.fieldListModel.clear();
        Iterator iterator = this.metaData.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith("selector_")) continue;
            this.fieldListModel.addElement(string.substring("selector_".length()));
        }
    }

    private void setupWordSelector() {
        Object v = this.wordListModels.get(this.currentField);
        if (v != null) {
            this.wordListModel = (DefaultListModel)v;
            this.wordList.setModel(this.wordListModel);
        } else {
            this.wordListModel = new DefaultListModel();
            this.wordList.setModel(this.wordListModel);
            this.wordListModels.put(this.currentField, this.wordListModel);
            this.wordListModel.clear();
            Vector vector = this.metaData.getData("selector_" + this.currentField);
            if (vector != null) {
                this.wordSet = new TreeSet(vector);
                Iterator iterator = this.wordSet.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    int n = this.findPos(this.wordListModel, string);
                    this.wordListModel.add(n, string);
                }
            }
        }
    }

    private int findPos(DefaultListModel defaultListModel, String string) {
        for (int i = 0; i < defaultListModel.size(); ++i) {
            String string2 = (String)defaultListModel.get(i);
            if (string.compareToIgnoreCase(string2) >= 0) continue;
            return i;
        }
        return this.wordListModel.size();
    }

    private void initLayout() {
        this.fieldNameField.setEnabled(false);
        this.fieldList.setVisibleRowCount(4);
        this.wordList.setVisibleRowCount(10);
        this.fieldList.setPrototypeCellValue("Uren luren himmelturen, ja Besseggen.");
        this.wordList.setPrototypeCellValue("Uren luren himmelturen, ja Besseggen.");
        this.fieldPan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Field name")));
        this.wordPan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Keyword")));
        this.fieldPan.setLayout(this.gbl);
        this.wordPan.setLayout(this.gbl);
        this.con.insets = new Insets(2, 2, 2, 2);
        this.con.fill = 1;
        this.con.gridwidth = 2;
        this.con.weightx = 1.0;
        this.con.weighty = 1.0;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.fPane, this.con);
        this.fieldPan.add(this.fPane);
        this.gbl.setConstraints(this.wPane, this.con);
        this.wordPan.add(this.wPane);
        this.con.gridwidth = 1;
        this.con.gridx = 2;
        this.con.gridheight = 2;
        this.gbl.setConstraints(this.fieldNamePan, this.con);
        this.fieldPan.add(this.fieldNamePan);
        this.gbl.setConstraints(this.wordEditPan, this.con);
        this.wordPan.add(this.wordEditPan);
        this.con.gridx = 0;
        this.con.gridy = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.con.fill = 0;
        this.con.anchor = 17;
        this.gbl.setConstraints(this.newField, this.con);
        this.fieldPan.add(this.newField);
        this.gbl.setConstraints(this.newWord, this.con);
        this.wordPan.add(this.newWord);
        this.con.gridx = 1;
        this.gbl.setConstraints(this.removeField, this.con);
        this.fieldPan.add(this.removeField);
        this.gbl.setConstraints(this.removeWord, this.con);
        this.wordPan.add(this.removeWord);
        this.con.anchor = 17;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.fieldNameField, this.con);
        this.fieldNamePan.add(this.fieldNameField);
        this.gbl.setConstraints(this.wordEditField, this.con);
        this.wordEditPan.add(this.wordEditField);
        this.buttonPan.add(this.help);
        this.buttonPan.add(Box.createHorizontalStrut(10));
        this.buttonPan.add(this.ok);
        this.buttonPan.add(this.apply);
        this.buttonPan.add(this.cancel);
        this.con.fill = 1;
        this.getContentPane().setLayout(this.gbl);
        this.con.weightx = 1.0;
        this.con.weighty = 0.5;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.fieldPan, this.con);
        this.getContentPane().add(this.fieldPan);
        this.con.gridy = 1;
        this.gbl.setConstraints(this.wordPan, this.con);
        this.getContentPane().add(this.wordPan);
        this.con.weighty = 0.0;
        this.con.gridy = 2;
        this.con.insets = new Insets(12, 2, 2, 2);
        this.gbl.setConstraints(this.buttonPan, this.con);
        this.getContentPane().add(this.buttonPan);
    }
}

