/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.util.TXMLReader;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BibtexFields {
    public static final String KEY_FIELD = "bibtexkey";
    public static final String SEARCH = "__search";
    public static final String GROUPSEARCH = "__groupsearch";
    public static final String MARKED = "__markedentry";
    public static final String OWNER = "owner";
    public static final String TIMESTAMP = "timestamp";
    public static final String ENTRYTYPE = "entrytype";
    public static final String DEFAULT_BIBTEXENTRY_ID = "__ID";
    public static final String[] DEFAULT_INSPECTION_FIELDS = new String[]{"author", "title", "year", "bibtexkey"};
    private static final BibtexFields runtime = new BibtexFields();
    private HashMap fieldSet = new HashMap();
    private Object[] PUBLIC_FIELDS = null;

    private BibtexFields() {
        BibtexSingleField bibtexSingleField = null;
        this.add(new BibtexSingleField("address", true, 0.3));
        this.add(new BibtexSingleField("annote", true, 1.5));
        this.add(new BibtexSingleField("author", true, 0.5, 280));
        this.add(new BibtexSingleField("booktitle", true, 175));
        this.add(new BibtexSingleField("chapter", true, 0.3));
        this.add(new BibtexSingleField("crossref", true, 0.3));
        this.add(new BibtexSingleField("edition", true, 0.3));
        this.add(new BibtexSingleField("editor", true, 0.5, 280));
        this.add(new BibtexSingleField("howpublished", true, 0.5));
        this.add(new BibtexSingleField("institution", true, 0.5));
        bibtexSingleField = new BibtexSingleField("journal", true, 0.3);
        bibtexSingleField.setExtras("journalNames");
        this.add(bibtexSingleField);
        this.add(new BibtexSingleField("key", true));
        this.add(new BibtexSingleField("month", true, 0.3));
        this.add(new BibtexSingleField("note", true, 0.5));
        this.add(new BibtexSingleField("number", true, 0.3, 60));
        this.add(new BibtexSingleField("organization", true, 0.5));
        this.add(new BibtexSingleField("pages", true, 0.3));
        this.add(new BibtexSingleField("publisher", true, 0.5));
        this.add(new BibtexSingleField("school", true, 0.5));
        this.add(new BibtexSingleField("series", true, 0.3));
        this.add(new BibtexSingleField("title", true, 400));
        this.add(new BibtexSingleField("type", true, 0.3));
        this.add(new BibtexSingleField("volume", true, 0.3, 60));
        this.add(new BibtexSingleField("year", true, 0.3, 60));
        bibtexSingleField = new BibtexSingleField(KEY_FIELD, true);
        bibtexSingleField.setPrivate();
        this.add(bibtexSingleField);
        bibtexSingleField = new BibtexSingleField("doi", true, 0.3);
        bibtexSingleField.setExtras("external");
        this.add(bibtexSingleField);
        this.add(new BibtexSingleField("eid", true, 0.3));
        bibtexSingleField = new BibtexSingleField("date", true);
        bibtexSingleField.setPrivate();
        this.add(bibtexSingleField);
        bibtexSingleField = new BibtexSingleField("citeseercitationcount", false, 0.3, 75);
        bibtexSingleField.setAlternativeDisplayName("Popularity");
        this.add(bibtexSingleField);
        this.add(new BibtexSingleField("location", false));
        this.add(new BibtexSingleField("abstract", false, 1.5, 400));
        bibtexSingleField = new BibtexSingleField("url", false, 0.3);
        bibtexSingleField.setExtras("external");
        this.add(bibtexSingleField);
        bibtexSingleField = new BibtexSingleField("citeseerurl", false, 0.3);
        bibtexSingleField.setExtras("external");
        this.add(bibtexSingleField);
        bibtexSingleField = new BibtexSingleField("pdf", false, 0.3);
        bibtexSingleField.setExtras("browseDoc");
        this.add(bibtexSingleField);
        bibtexSingleField = new BibtexSingleField("ps", false, 0.3);
        bibtexSingleField.setExtras("browseDocZip");
        this.add(bibtexSingleField);
        this.add(new BibtexSingleField("comment", false, 0.5));
        this.add(new BibtexSingleField("keywords", false, 0.3));
        this.add(new BibtexSingleField("search", false, 75));
        bibtexSingleField = new BibtexSingleField(GUIGlobals.NUMBER_COL, false, 32);
        bibtexSingleField.setPrivate();
        bibtexSingleField.setWriteable(false);
        bibtexSingleField.setDisplayable(false);
        this.add(bibtexSingleField);
        bibtexSingleField = new BibtexSingleField(OWNER, false, 0.3);
        bibtexSingleField.setPrivate();
        this.add(bibtexSingleField);
        bibtexSingleField = new BibtexSingleField(TIMESTAMP, false, 0.3);
        bibtexSingleField.setExtras("datepicker");
        bibtexSingleField.setPrivate();
        this.add(bibtexSingleField);
        bibtexSingleField = new BibtexSingleField(ENTRYTYPE, false, 75);
        bibtexSingleField.setPrivate();
        this.add(bibtexSingleField);
        bibtexSingleField = new BibtexSingleField(SEARCH, false);
        bibtexSingleField.setPrivate();
        bibtexSingleField.setWriteable(false);
        bibtexSingleField.setDisplayable(false);
        this.add(bibtexSingleField);
        bibtexSingleField = new BibtexSingleField(GROUPSEARCH, false);
        bibtexSingleField.setPrivate();
        bibtexSingleField.setWriteable(false);
        bibtexSingleField.setDisplayable(false);
        this.add(bibtexSingleField);
        bibtexSingleField = new BibtexSingleField(MARKED, false);
        bibtexSingleField.setPrivate();
        bibtexSingleField.setWriteable(true);
        bibtexSingleField.setDisplayable(false);
        this.add(bibtexSingleField);
        this.readXML("/resource/fields/fields.xml");
        Vector<String> vector = new Vector<String>(this.fieldSet.size());
        Iterator iterator = this.fieldSet.values().iterator();
        while (iterator.hasNext()) {
            BibtexSingleField bibtexSingleField2 = (BibtexSingleField)iterator.next();
            if (!bibtexSingleField2.isPublic()) continue;
            vector.add(bibtexSingleField2.getFieldName());
        }
        this.PUBLIC_FIELDS = vector.toArray();
        Arrays.sort(this.PUBLIC_FIELDS);
    }

    private void add(BibtexSingleField bibtexSingleField) {
        String string = bibtexSingleField.name;
        this.fieldSet.put(string, bibtexSingleField);
    }

    private void readXML(String string) {
        TXMLReader tXMLReader = new TXMLReader(string);
        if (tXMLReader.isReady()) {
            NodeList nodeList = tXMLReader.getNodes("field");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                BibtexSingleField bibtexSingleField;
                Element element = (Element)nodeList.item(i);
                String string2 = tXMLReader.readStringAttribute(element, "name", null);
                if (string2 == null || (bibtexSingleField = (BibtexSingleField)this.fieldSet.get(string2 = string2.toLowerCase())) != null) continue;
                bibtexSingleField = new BibtexSingleField(tXMLReader, element);
                this.fieldSet.put(string2, bibtexSingleField);
            }
        }
    }

    private static final BibtexSingleField getField(String string) {
        if (string != null) {
            return (BibtexSingleField)BibtexFields.runtime.fieldSet.get(string.toLowerCase());
        }
        return null;
    }

    public static String getFieldExtras(String string) {
        BibtexSingleField bibtexSingleField = BibtexFields.getField(string);
        if (bibtexSingleField != null) {
            return bibtexSingleField.getExtras();
        }
        return null;
    }

    public static double getFieldWeight(String string) {
        BibtexSingleField bibtexSingleField = BibtexFields.getField(string);
        if (bibtexSingleField != null) {
            return bibtexSingleField.getWeight();
        }
        return 1.0;
    }

    public static void setFieldWeight(String string, double d) {
        BibtexSingleField bibtexSingleField = BibtexFields.getField(string);
        if (bibtexSingleField != null) {
            bibtexSingleField.setWeight(d);
        }
    }

    public static int getFieldLength(String string) {
        BibtexSingleField bibtexSingleField = BibtexFields.getField(string);
        if (bibtexSingleField != null) {
            return bibtexSingleField.getLength();
        }
        return GUIGlobals.DEFAULT_FIELD_LENGTH;
    }

    public static String getFieldDisplayName(String string) {
        BibtexSingleField bibtexSingleField = BibtexFields.getField(string);
        if (bibtexSingleField != null) {
            return bibtexSingleField.getAlternativeDisplayName();
        }
        return null;
    }

    public static boolean isWriteableField(String string) {
        BibtexSingleField bibtexSingleField = BibtexFields.getField(string);
        if (bibtexSingleField != null) {
            return bibtexSingleField.isWriteable();
        }
        return true;
    }

    public static boolean isDisplayableField(String string) {
        BibtexSingleField bibtexSingleField = BibtexFields.getField(string);
        if (bibtexSingleField != null) {
            return bibtexSingleField.isDisplayable();
        }
        return true;
    }

    public static boolean isStandardField(String string) {
        BibtexSingleField bibtexSingleField = BibtexFields.getField(string);
        if (bibtexSingleField != null) {
            return bibtexSingleField.isStandard();
        }
        return false;
    }

    public static Object[] getAllFieldNames() {
        return BibtexFields.runtime.PUBLIC_FIELDS;
    }

    public static String getFieldName(int n) {
        return (String)BibtexFields.runtime.PUBLIC_FIELDS[n];
    }

    public static int numberOfPublicFields() {
        return BibtexFields.runtime.PUBLIC_FIELDS.length;
    }

    private class BibtexSingleField {
        private static final int STANDARD = 1;
        private static final int PRIVATE = 2;
        private static final int DISPLAYABLE = 4;
        private static final int WRITEABLE = 8;
        private String name;
        private int flag = 12;
        private int length = GUIGlobals.DEFAULT_FIELD_LENGTH;
        private double weight = 1.0;
        private String alternativeDisplayName = null;
        private String extras = null;

        public BibtexSingleField(String string) {
            this.name = string;
        }

        public BibtexSingleField(String string, boolean bl) {
            this.name = string;
            this.setFlag(bl, 1);
        }

        public BibtexSingleField(String string, boolean bl, double d) {
            this.name = string;
            this.setFlag(bl, 1);
            this.weight = d;
        }

        public BibtexSingleField(String string, boolean bl, int n) {
            this.name = string;
            this.setFlag(bl, 1);
            this.length = n;
        }

        public BibtexSingleField(String string, boolean bl, double d, int n) {
            this.name = string;
            this.setFlag(bl, 1);
            this.weight = d;
            this.length = n;
        }

        public BibtexSingleField(TXMLReader tXMLReader, Element element) {
            this.flag = 12;
            this.name = tXMLReader.readStringAttribute(element, "name", "field");
            this.name = this.name.toLowerCase();
            String string = tXMLReader.readStringAttribute(element, "weight", null);
            if (string != null) {
                int n = string.toLowerCase().hashCode();
                if (n == "small".hashCode()) {
                    this.weight = 0.3;
                } else if (n == "medium".hashCode()) {
                    this.weight = 0.5;
                } else if (n == "large".hashCode()) {
                    this.weight = 1.5;
                } else {
                    try {
                        this.weight = Double.parseDouble(string);
                        if (this.weight < 0.0 || this.weight > 2.0) {
                            this.weight = 1.0;
                        }
                    }
                    catch (Exception exception) {
                        this.weight = 1.0;
                    }
                }
            }
            this.length = tXMLReader.readIntegerAttribute(element, "length", GUIGlobals.DEFAULT_FIELD_LENGTH);
            this.extras = tXMLReader.readStringAttribute(element, "extras", null);
        }

        private void setFlag(boolean bl, int n) {
            this.flag = bl ? (this.flag |= n) : (this.flag &= 0xFF ^ n);
        }

        private boolean isSet(int n) {
            return (this.flag & n) == n;
        }

        public boolean isStandard() {
            return this.isSet(1);
        }

        public void setPrivate() {
            this.flag |= 2;
        }

        public boolean isPrivate() {
            return this.isSet(2);
        }

        public void setPublic() {
            this.setFlag(false, 2);
        }

        public boolean isPublic() {
            return !this.isSet(2);
        }

        public void setDisplayable(boolean bl) {
            this.setFlag(bl, 4);
        }

        public boolean isDisplayable() {
            return this.isSet(4);
        }

        public void setWriteable(boolean bl) {
            this.setFlag(bl, 8);
        }

        public boolean isWriteable() {
            return this.isSet(8);
        }

        public void setAlternativeDisplayName(String string) {
            this.alternativeDisplayName = string;
        }

        public String getAlternativeDisplayName() {
            return this.alternativeDisplayName;
        }

        public void setExtras(String string) {
            this.extras = string;
        }

        public String getExtras() {
            return this.extras;
        }

        public void setWeight(double d) {
            this.weight = d;
        }

        public double getWeight() {
            return this.weight;
        }

        public int getLength() {
            return this.length;
        }

        public String getFieldName() {
            return this.name;
        }
    }
}

