/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;
import net.sf.jabref.export.FieldFormatter;

public class BibtexEntry {
    public static final String ID_FIELD = "id";
    private String _id;
    private BibtexEntryType _type;
    private Map _fields = new HashMap();
    VetoableChangeSupport _changeSupport = new VetoableChangeSupport(this);
    private boolean searchHit;
    private boolean groupHit;

    public BibtexEntry() {
        this(Util.createNeutralId());
    }

    public BibtexEntry(String string) {
        this(string, BibtexEntryType.OTHER);
    }

    public BibtexEntry(String string, BibtexEntryType bibtexEntryType) {
        if (string == null) {
            throw new NullPointerException("Every BibtexEntry must have an ID");
        }
        this._id = string;
        this.setType(bibtexEntryType);
    }

    public String[] getOptionalFields() {
        return this._type.getOptionalFields();
    }

    public String[] getRequiredFields() {
        return this._type.getRequiredFields();
    }

    public String[] getGeneralFields() {
        return this._type.getGeneralFields();
    }

    public Object[] getAllFields() {
        return this._fields.keySet().toArray();
    }

    public String describeRequiredFields() {
        return this._type.describeRequiredFields();
    }

    public boolean hasAllRequiredFields() {
        return this._type.hasAllRequiredFields(this);
    }

    public BibtexEntryType getType() {
        return this._type;
    }

    public void setType(BibtexEntryType bibtexEntryType) {
        if (bibtexEntryType == null) {
            throw new NullPointerException("Every BibtexEntry must have a type.  Instead of null, use type OTHER");
        }
        this._type = bibtexEntryType;
    }

    public boolean updateType() {
        BibtexEntryType bibtexEntryType = BibtexEntryType.getType(this._type.getName());
        if (bibtexEntryType != null) {
            this._type = bibtexEntryType;
            return true;
        }
        this._type = BibtexEntryType.TYPELESS;
        return false;
    }

    public void setId(String string) throws KeyCollisionException {
        if (string == null) {
            throw new NullPointerException("Every BibtexEntry must have an ID");
        }
        try {
            this.firePropertyChangedEvent(ID_FIELD, this._id, string);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new KeyCollisionException("Couldn't change ID: " + propertyVetoException);
        }
        this._id = string;
    }

    public String getId() {
        return this._id;
    }

    public Object getField(String string) {
        return this._fields.get(string);
    }

    public String getCiteKey() {
        return this._fields.containsKey("bibtexkey") ? (String)this._fields.get("bibtexkey") : null;
    }

    public void setField(Map map) {
        this._fields.putAll(map);
    }

    public void setField(String string, Object object) {
        if (ID_FIELD.equals(string)) {
            throw new IllegalArgumentException("The field name '" + string + "' is reserved");
        }
        Object v = this._fields.get(string);
        try {
            this._fields.put(string, object);
            this.firePropertyChangedEvent(string, v, object);
        }
        catch (PropertyVetoException propertyVetoException) {
            this._fields.put(string, v);
            throw new IllegalArgumentException("Change rejected: " + propertyVetoException);
        }
    }

    public void clearField(String string) {
        if (ID_FIELD.equals(string)) {
            throw new IllegalArgumentException("The field name '" + string + "' is reserved");
        }
        Object v = this._fields.get(string);
        this._fields.remove(string);
        try {
            this.firePropertyChangedEvent(string, v, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new IllegalArgumentException("Change rejected: " + propertyVetoException);
        }
    }

    protected boolean allFieldsPresent(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.getField(stringArray[i]) != null) continue;
            return false;
        }
        return true;
    }

    private void firePropertyChangedEvent(String string, Object object, Object object2) throws PropertyVetoException {
        this._changeSupport.fireVetoableChange(new PropertyChangeEvent(this, string, object, object2));
    }

    public void addPropertyChangeListener(VetoableChangeListener vetoableChangeListener) {
        this._changeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removePropertyChangeListener(VetoableChangeListener vetoableChangeListener) {
        this._changeSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void write(Writer writer, FieldFormatter fieldFormatter, boolean bl) throws IOException {
        int n;
        writer.write("@" + this._type.getName().toUpperCase() + "{");
        String string = Util.shaveString((String)this.getField("bibtexkey"));
        writer.write((string == null ? "" : string) + "," + Globals.NEWLINE);
        HashMap hashMap = new HashMap();
        hashMap.put("bibtexkey", null);
        boolean bl2 = false;
        String[] stringArray = this.getRequiredFields();
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                bl2 |= this.writeField(stringArray[n], writer, fieldFormatter, bl2);
                hashMap.put(stringArray[n], null);
            }
        }
        if ((stringArray = this.getOptionalFields()) != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (hashMap.containsKey(stringArray[n])) continue;
                bl2 |= this.writeField(stringArray[n], writer, fieldFormatter, bl2);
                hashMap.put(stringArray[n], null);
            }
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator<Object> iterator = this._fields.keySet().iterator();
        while (iterator.hasNext()) {
            boolean bl3;
            String string2 = (String)iterator.next();
            boolean bl4 = bl3 = bl ? BibtexFields.isWriteableField(string2) : BibtexFields.isDisplayableField(string2);
            if (hashMap.containsKey(string2) || !bl3) continue;
            treeSet.add(string2);
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            bl2 |= this.writeField((String)iterator.next(), writer, fieldFormatter, bl2);
        }
        writer.write((bl2 ? Globals.NEWLINE : "") + "}" + Globals.NEWLINE);
    }

    private boolean writeField(String string, Writer writer, FieldFormatter fieldFormatter, boolean bl) throws IOException {
        Object object = this.getField(string);
        if (object != null) {
            if (bl) {
                writer.write("," + Globals.NEWLINE);
            }
            writer.write("  " + string + " = ");
            try {
                writer.write(fieldFormatter.format(object.toString(), string));
            }
            catch (Throwable throwable) {
                throw new IOException(Globals.lang("Error in field") + " '" + string + "': " + throwable.getMessage());
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        BibtexEntry bibtexEntry = new BibtexEntry(this._id, this._type);
        bibtexEntry._fields = (Map)((HashMap)this._fields).clone();
        return bibtexEntry;
    }

    public String toString() {
        return this.getType().getName() + ":" + this.getField("bibtexkey");
    }

    public boolean isSearchHit() {
        return this.searchHit;
    }

    public void setSearchHit(boolean bl) {
        this.searchHit = bl;
    }

    public boolean isGroupHit() {
        return this.groupHit;
    }

    public void setGroupHit(boolean bl) {
        this.groupHit = bl;
    }

    public String getAuthorTitleYear(int n) {
        String[] stringArray = new String[]{(String)this.getField("author"), (String)this.getField("title"), (String)this.getField("year")};
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            stringArray[i] = "N/A";
        }
        String string = stringArray[0] + ": \"" + stringArray[1] + "\" (" + stringArray[2] + ")";
        if (n <= 0 || string.length() <= n) {
            return string;
        }
        return string.substring(0, n + 1) + "...";
    }
}

