/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexString;
import net.sf.jabref.DatabaseChangeEvent;
import net.sf.jabref.DatabaseChangeListener;
import net.sf.jabref.EntrySorter;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;

public class BibtexDatabase {
    Map _entries = new Hashtable();
    String _preamble = null;
    HashMap _strings = new HashMap();
    Vector _strings_ = new Vector();
    Hashtable _autoCompleters = null;
    Set changeListeners = new HashSet();
    private BibtexDatabase ths = this;
    private HashMap allKeys = new HashMap();
    private final VetoableChangeListener listener = new VetoableChangeListener(){

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (propertyChangeEvent.getPropertyName() == null) {
                BibtexDatabase.this.fireDatabaseChanged(new DatabaseChangeEvent(BibtexDatabase.this.ths, DatabaseChangeEvent.CHANGING_ENTRY, (BibtexEntry)propertyChangeEvent.getSource()));
            } else if ("id".equals(propertyChangeEvent.getPropertyName())) {
                Object v = BibtexDatabase.this._entries.remove((String)propertyChangeEvent.getOldValue());
                if (v != propertyChangeEvent.getSource()) {
                    BibtexDatabase.this._entries.put(propertyChangeEvent.getOldValue(), v);
                    throw new PropertyVetoException("Wrong old ID", propertyChangeEvent);
                }
                if (BibtexDatabase.this._entries.get(propertyChangeEvent.getNewValue()) != null) {
                    BibtexDatabase.this._entries.put(propertyChangeEvent.getOldValue(), v);
                    throw new PropertyVetoException("New ID already in use, please choose another", propertyChangeEvent);
                }
                BibtexDatabase.this._entries.put((String)propertyChangeEvent.getNewValue(), (BibtexEntry)propertyChangeEvent.getSource());
            } else {
                BibtexDatabase.this.fireDatabaseChanged(new DatabaseChangeEvent(BibtexDatabase.this.ths, DatabaseChangeEvent.CHANGED_ENTRY, (BibtexEntry)propertyChangeEvent.getSource()));
            }
        }
    };

    public synchronized int getEntryCount() {
        return this._entries.size();
    }

    public synchronized Set getKeySet() {
        return this._entries.keySet();
    }

    public synchronized EntrySorter getSorter(Comparator comparator) {
        EntrySorter entrySorter = new EntrySorter(this._entries, comparator);
        this.addDatabaseChangeListener(entrySorter);
        return entrySorter;
    }

    public Map getEntryMap() {
        return this._entries;
    }

    public synchronized BibtexEntry getEntryById(String string) {
        return (BibtexEntry)this._entries.get(string);
    }

    public synchronized Collection getEntries() {
        return this._entries.values();
    }

    public synchronized BibtexEntry getEntryByKey(String string) {
        BibtexEntry bibtexEntry = null;
        int n = string.hashCode();
        Set set = this._entries.keySet();
        if (set != null) {
            Iterator iterator = set.iterator();
            boolean bl = iterator.hasNext();
            while (bl) {
                String string2 = (String)iterator.next();
                BibtexEntry bibtexEntry2 = this.getEntryById(string2);
                if (bibtexEntry2 == null || bibtexEntry2.getCiteKey() == null) continue;
                String string3 = bibtexEntry2.getCiteKey();
                if (string3 != null) {
                    if (n == string3.hashCode()) {
                        bl = false;
                        bibtexEntry = bibtexEntry2;
                        continue;
                    }
                    bl = iterator.hasNext();
                    continue;
                }
                bl = iterator.hasNext();
            }
        }
        return bibtexEntry;
    }

    public synchronized BibtexEntry[] getEntriesByKey(String string) {
        Vector<BibtexEntry> vector = new Vector<BibtexEntry>();
        BibtexEntry[] bibtexEntryArray = this._entries.entrySet().iterator();
        while (bibtexEntryArray.hasNext()) {
            BibtexEntry bibtexEntry = (BibtexEntry)bibtexEntryArray.next().getValue();
            if (!string.equals(bibtexEntry.getCiteKey())) continue;
            vector.add(bibtexEntry);
        }
        bibtexEntryArray = new BibtexEntry[vector.size()];
        return vector.toArray(bibtexEntryArray);
    }

    public synchronized boolean insertEntry(BibtexEntry bibtexEntry) throws KeyCollisionException {
        String string = bibtexEntry.getId();
        if (this.getEntryById(string) != null) {
            throw new KeyCollisionException("ID is already in use, please choose another");
        }
        bibtexEntry.addPropertyChangeListener(this.listener);
        this._entries.put(string, bibtexEntry);
        this.fireDatabaseChanged(new DatabaseChangeEvent(this, DatabaseChangeEvent.ADDED_ENTRY, bibtexEntry));
        return this.checkForDuplicateKeyAndAdd(null, bibtexEntry.getCiteKey(), false);
    }

    public synchronized BibtexEntry removeEntry(String string) {
        BibtexEntry bibtexEntry = (BibtexEntry)this._entries.remove(string);
        this.removeKeyFromSet(bibtexEntry.getCiteKey());
        if (bibtexEntry != null) {
            bibtexEntry.removePropertyChangeListener(this.listener);
        }
        this.fireDatabaseChanged(new DatabaseChangeEvent(this, DatabaseChangeEvent.REMOVED_ENTRY, bibtexEntry));
        return bibtexEntry;
    }

    public synchronized boolean setCiteKeyForEntry(String string, String string2) {
        if (!this._entries.containsKey(string)) {
            return false;
        }
        BibtexEntry bibtexEntry = this.getEntryById(string);
        String string3 = bibtexEntry.getCiteKey();
        if (string2 != null) {
            bibtexEntry.setField("bibtexkey", string2);
        } else {
            bibtexEntry.clearField("bibtexkey");
        }
        return this.checkForDuplicateKeyAndAdd(string3, bibtexEntry.getCiteKey(), false);
    }

    public synchronized void setPreamble(String string) {
        this._preamble = string;
    }

    public synchronized String getPreamble() {
        return this._preamble;
    }

    public synchronized void addString(BibtexString bibtexString) throws KeyCollisionException {
        Iterator iterator = this._strings.keySet().iterator();
        while (iterator.hasNext()) {
            if (!((BibtexString)this._strings.get(iterator.next())).getName().equals(bibtexString.getName())) continue;
            throw new KeyCollisionException("A string with this label already exists,");
        }
        if (this._strings.containsKey(bibtexString.getId())) {
            throw new KeyCollisionException("Duplicate BibtexString id.");
        }
        this._strings.put(bibtexString.getId(), bibtexString);
    }

    public synchronized void removeString(String string) {
        this._strings.remove(string);
    }

    public Set getStringKeySet() {
        return this._strings.keySet();
    }

    public synchronized BibtexString getString(Object object) {
        return (BibtexString)this._strings.get(object);
    }

    public synchronized int getStringCount() {
        return this._strings.size();
    }

    public synchronized boolean hasStringLabel(String string) {
        Iterator iterator = this._strings.keySet().iterator();
        while (iterator.hasNext()) {
            if (!((BibtexString)this._strings.get(iterator.next())).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public String resolveForStrings(String string) {
        return this.resolveContent(string, new HashSet());
    }

    private String resolveString(String string, HashSet hashSet) {
        Iterator<Object> iterator = this._strings.keySet().iterator();
        while (iterator.hasNext()) {
            BibtexString bibtexString = (BibtexString)this._strings.get(iterator.next());
            if (!bibtexString.getName().toLowerCase().equals(string.toLowerCase())) continue;
            if (hashSet.contains(bibtexString.getId())) {
                Util.pr("Stopped due to circular reference in strings: " + string);
                return string;
            }
            hashSet.add(bibtexString.getId());
            String string2 = bibtexString.getContent();
            string2 = this.resolveContent(string2, hashSet);
            hashSet.remove(bibtexString.getId());
            return string2;
        }
        iterator = Globals.MONTH_STRINGS.get(string.toLowerCase());
        if (iterator != null) {
            return (String)((Object)iterator);
        }
        return string;
    }

    private String resolveContent(String string, HashSet hashSet) {
        if (string.matches(".*#[^#]+#.*")) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            int n2 = 0;
            while ((n2 = string.indexOf("#", n)) >= 0) {
                int n3;
                if (n2 > 0) {
                    stringBuffer.append(string.substring(n, n2));
                }
                if ((n3 = string.indexOf("#", n2 + 1)) >= 0) {
                    String string2;
                    String string3 = string.substring(n2 + 1, n3);
                    if (string3.equals(string2 = this.resolveString(string3, hashSet))) {
                        stringBuffer.append(string.substring(n2, n3 + 1));
                    } else {
                        stringBuffer.append(string2);
                    }
                    n = n3 + 1;
                    continue;
                }
                stringBuffer.append(string.substring(n2));
                n = string.length();
                break;
            }
            if (n < string.length() - 1) {
                stringBuffer.append(string.substring(n));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public boolean checkForDuplicateKeyAndAdd(String string, String string2, boolean bl) {
        boolean bl2 = false;
        if (string == null) {
            bl2 = this.addKeyToSet(string2);
        } else if (string.equals(string2)) {
            bl2 = false;
        } else {
            this.removeKeyFromSet(string);
            bl2 = this.addKeyToSet(string2);
        }
        if (bl2 && bl) {
            JOptionPane.showMessageDialog(null, Globals.lang("Warning there is a duplicate key") + ":" + string2, Globals.lang("Duplicate Key Warning"), 2);
        }
        return bl2;
    }

    public int getNumberOfKeyOccurences(String string) {
        Object v = this.allKeys.get(string);
        if (v == null) {
            return 0;
        }
        return (Integer)v;
    }

    private boolean addKeyToSet(String string) {
        boolean bl = false;
        if (string == null || string.equals("")) {
            return false;
        }
        if (this.allKeys.containsKey(string)) {
            bl = true;
            this.allKeys.put(string, new Integer((Integer)this.allKeys.get(string) + 1));
        } else {
            this.allKeys.put(string, new Integer(1));
        }
        return bl;
    }

    private void removeKeyFromSet(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        if (this.allKeys.containsKey(string)) {
            Integer n = (Integer)this.allKeys.get(string);
            if (n == 1) {
                this.allKeys.remove(string);
            } else {
                this.allKeys.put(string, new Integer(n - 1));
            }
        }
    }

    public void fireDatabaseChanged(DatabaseChangeEvent databaseChangeEvent) {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((DatabaseChangeListener)iterator.next()).databaseChanged(databaseChangeEvent);
        }
    }

    public void addDatabaseChangeListener(DatabaseChangeListener databaseChangeListener) {
        this.changeListeners.add(databaseChangeListener);
    }

    public void removeDatabaseChangeListener(DatabaseChangeListener databaseChangeListener) {
        this.changeListeners.remove(databaseChangeListener);
    }
}

