/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Hashtable;
import java.util.Vector;
import java.util.WeakHashMap;

public class AuthorList {
    private Vector authors;
    private String authorsNatbib = null;
    private String authorsFirstFirstAnds = null;
    private String authorsAlph = null;
    private String[] authorsFirstFirst = new String[4];
    private String[] authorsLastOnly = new String[2];
    private String[] authorLastFirstAnds = new String[2];
    private String[] authorsLastFirst = new String[4];
    private String orig;
    private int token_start;
    private int token_end;
    private int token_abbr;
    private char token_term;
    private boolean token_case;
    private Vector tokens;
    private static final int TOKEN_GROUP_LENGTH = 4;
    private static final int OFFSET_TOKEN = 0;
    private static final int OFFSET_TOKEN_ABBR = 1;
    private static final int OFFSET_TOKEN_TERM = 2;
    int von_start;
    int last_start;
    int comma_first;
    int comma_second;
    private static final int TOKEN_EOF = 0;
    private static final int TOKEN_AND = 1;
    private static final int TOKEN_COMMA = 2;
    private static final int TOKEN_WORD = 3;
    private static final Hashtable tex_names = new Hashtable();
    static WeakHashMap authorCache;

    protected AuthorList(String string) {
        this.authors = new Vector(5);
        this.orig = string;
        this.token_start = 0;
        this.token_end = 0;
        while (this.token_start < this.orig.length()) {
            Author author = this.getAuthor();
            if (author == null) continue;
            this.authors.add(author);
        }
        this.orig = null;
        this.tokens = null;
    }

    public static AuthorList getAuthorList(String string) {
        AuthorList authorList = (AuthorList)authorCache.get(string);
        if (authorList == null) {
            authorList = new AuthorList(string);
            authorCache.put(string, authorList);
        }
        return authorList;
    }

    public static String fixAuthor_firstNameFirstCommas(String string, boolean bl, boolean bl2) {
        return AuthorList.getAuthorList(string).getAuthorsFirstFirst(bl, bl2);
    }

    public static String fixAuthor_firstNameFirst(String string) {
        return AuthorList.getAuthorList(string).getAuthorsFirstFirstAnds();
    }

    public static String fixAuthor_lastNameFirstCommas(String string, boolean bl, boolean bl2) {
        return AuthorList.getAuthorList(string).getAuthorsLastFirst(bl, bl2);
    }

    public static String fixAuthor_lastNameFirst(String string) {
        return AuthorList.getAuthorList(string).getAuthorsLastFirstAnds(false);
    }

    public static String fixAuthor_lastNameFirst(String string, boolean bl) {
        return AuthorList.getAuthorList(string).getAuthorsLastFirstAnds(bl);
    }

    public static String fixAuthor_lastNameOnlyCommas(String string, boolean bl) {
        return AuthorList.getAuthorList(string).getAuthorsLastOnly(bl);
    }

    public static String fixAuthorForAlphabetization(String string) {
        return AuthorList.getAuthorList(string).getAuthorsForAlphabetization();
    }

    public static String fixAuthor_Natbib(String string) {
        return AuthorList.getAuthorList(string).getAuthorsNatbib();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Author getAuthor() {
        String string;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        block27: {
            block26: {
                this.tokens = new Vector();
                this.von_start = -1;
                this.last_start = -1;
                this.comma_first = -1;
                this.comma_second = -1;
                block5: while (true) {
                    n8 = this.getToken();
                    switch (n8) {
                        case 0: 
                        case 1: {
                            break block5;
                        }
                        case 2: {
                            if (this.comma_first < 0) {
                                this.comma_first = this.tokens.size();
                                break;
                            }
                            if (this.comma_second >= 0) break;
                            this.comma_second = this.tokens.size();
                            break;
                        }
                        case 3: {
                            this.tokens.add(this.orig.substring(this.token_start, this.token_end));
                            this.tokens.add(this.orig.substring(this.token_start, this.token_abbr));
                            this.tokens.add(new Character(this.token_term));
                            this.tokens.add(this.token_case);
                            if (this.comma_first >= 0 || this.last_start >= 0) break;
                            if (this.von_start < 0) {
                                if (this.token_case) break;
                                this.von_start = this.tokens.size() - 4;
                                break;
                            }
                            if (this.last_start >= 0 || !this.token_case) break;
                            this.last_start = this.tokens.size() - 4;
                        }
                    }
                }
                if (this.tokens.size() == 0) {
                    return null;
                }
                n8 = -1;
                n7 = -1;
                n6 = -1;
                n5 = -1;
                n4 = 0;
                n3 = 0;
                n2 = 0;
                n = 0;
                if (this.comma_first >= 0) break block26;
                if (this.von_start < 0) {
                    n2 = this.tokens.size();
                    n6 = this.tokens.size() - 4;
                    n4 = n6;
                    if (n4 > 0) {
                        n8 = 0;
                    }
                    break block27;
                } else {
                    if (this.last_start >= 0) {
                        n2 = this.tokens.size();
                        n3 = n6 = this.last_start;
                    } else {
                        n3 = this.tokens.size();
                    }
                    n4 = n7 = this.von_start;
                    if (n4 > 0) {
                        n8 = 0;
                    }
                }
                break block27;
            }
            n4 = this.tokens.size();
            if (this.comma_second < 0) {
                if (this.comma_first < n4) {
                    n8 = this.comma_first;
                }
            } else {
                if (this.comma_second < n4) {
                    n8 = this.comma_second;
                }
                if (this.comma_first < (n = this.comma_second)) {
                    n5 = this.comma_first;
                }
            }
            if (this.von_start != 0) {
                n2 = this.comma_first;
                if (n2 > 0) {
                    n6 = 0;
                }
            } else {
                if (this.last_start < 0) {
                    n3 = this.comma_first;
                } else {
                    n2 = this.comma_first;
                    n3 = n6 = this.last_start;
                }
                n7 = 0;
            }
        }
        String string2 = n8 < 0 ? null : this.concatTokens(n8, n4, 0, false);
        String string3 = n8 < 0 ? null : this.concatTokens(n8, n4, 1, true);
        String string4 = n7 < 0 ? null : this.concatTokens(n7, n3, 0, false);
        String string5 = n6 < 0 ? null : this.concatTokens(n6, n2, 0, false);
        if (n5 < 0) {
            string = null;
            return new Author(string2, string3, string4, string5, string);
        }
        string = this.concatTokens(n5, n, 0, false);
        return new Author(string2, string3, string4, string5, string);
    }

    private String concatTokens(int n, int n2, int n3, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((String)this.tokens.get(n + n3));
        if (bl) {
            stringBuffer.append('.');
        }
        n += 4;
        while (n < n2) {
            stringBuffer.append(this.tokens.get(n - 4 + 2));
            stringBuffer.append((String)this.tokens.get(n + n3));
            if (bl) {
                stringBuffer.append('.');
            }
            n += 4;
        }
        return stringBuffer.toString();
    }

    private int getToken() {
        int n;
        this.token_start = this.token_end;
        while (this.token_start < this.orig.length() && ((n = this.orig.charAt(this.token_start)) == 126 || n == 45 || Character.isWhitespace((char)n))) {
            ++this.token_start;
        }
        this.token_end = this.token_start;
        if (this.token_start >= this.orig.length()) {
            return 0;
        }
        if (this.orig.charAt(this.token_start) == ',') {
            ++this.token_end;
            return 2;
        }
        this.token_abbr = -1;
        this.token_term = (char)32;
        this.token_case = true;
        n = 0;
        int n2 = -1;
        boolean bl = false;
        while (this.token_end < this.orig.length()) {
            char c = this.orig.charAt(this.token_end);
            if (c == '{') {
                ++n;
            }
            if (n > 0 && c == '}') {
                --n;
            }
            if (bl && this.token_abbr < 0 && n == 0) {
                this.token_abbr = this.token_end;
            }
            if (!bl && n2 < 0 && Character.isLetter(c)) {
                this.token_case = Character.isUpperCase(c);
                bl = true;
            }
            if (n2 >= 0 && !Character.isLetter(c)) {
                String string;
                if (!bl && tex_names.get(string = this.orig.substring(n2 + 1, this.token_end)) != null) {
                    this.token_case = Character.isUpperCase(string.charAt(0));
                    bl = true;
                }
                n2 = -1;
            }
            if (c == '\\') {
                n2 = this.token_end;
            }
            if (n == 0 && (c == ',' || c == '~' || Character.isWhitespace(c))) break;
            ++this.token_end;
        }
        if (this.token_abbr < 0) {
            this.token_abbr = this.token_end;
        }
        if (this.token_end < this.orig.length() && this.orig.charAt(this.token_end) == '-') {
            this.token_term = (char)45;
        }
        if (this.orig.substring(this.token_start, this.token_end).equalsIgnoreCase("and")) {
            return 1;
        }
        return 3;
    }

    public int size() {
        return this.authors.size();
    }

    public Author getAuthor(int n) {
        return (Author)this.authors.get(n);
    }

    public String getAuthorsNatbib() {
        if (this.authorsNatbib != null) {
            return this.authorsNatbib;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.size() > 0) {
            stringBuffer.append(this.getAuthor(0).getLastOnly());
            if (this.size() == 2) {
                stringBuffer.append(" and ");
                stringBuffer.append(this.getAuthor(1).getLastOnly());
            } else if (this.size() > 2) {
                stringBuffer.append(" et al.");
            }
        }
        this.authorsNatbib = stringBuffer.toString();
        return this.authorsNatbib;
    }

    public String getAuthorsLastOnly(boolean bl) {
        int n;
        int n2 = n = bl ? 0 : 1;
        if (this.authorsLastOnly[n] != null) {
            return this.authorsLastOnly[n];
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.size() > 0) {
            int n3;
            stringBuffer.append(this.getAuthor(0).getLastOnly());
            for (n3 = 1; n3 < this.size() - 1; ++n3) {
                stringBuffer.append(", ");
                stringBuffer.append(this.getAuthor(n3).getLastOnly());
            }
            if (this.size() > 2 && bl) {
                stringBuffer.append(",");
            }
            if (this.size() > 1) {
                stringBuffer.append(" and ");
                stringBuffer.append(this.getAuthor(n3).getLastOnly());
            }
        }
        this.authorsLastOnly[n] = stringBuffer.toString();
        return this.authorsLastOnly[n];
    }

    public String getAuthorsLastFirst(boolean bl, boolean bl2) {
        int n = bl ? 0 : 1;
        if (this.authorsLastFirst[n += bl2 ? 0 : 2] != null) {
            return this.authorsLastFirst[n];
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.size() > 0) {
            int n2;
            stringBuffer.append(this.getAuthor(0).getLastFirst(bl));
            for (n2 = 1; n2 < this.size() - 1; ++n2) {
                stringBuffer.append(", ");
                stringBuffer.append(this.getAuthor(n2).getLastFirst(bl));
            }
            if (this.size() > 2 && bl2) {
                stringBuffer.append(",");
            }
            if (this.size() > 1) {
                stringBuffer.append(" and ");
                stringBuffer.append(this.getAuthor(n2).getLastFirst(bl));
            }
        }
        this.authorsLastFirst[n] = stringBuffer.toString();
        return this.authorsLastFirst[n];
    }

    public String getAuthorsLastFirstAnds(boolean bl) {
        int n;
        int n2 = n = bl ? 0 : 1;
        if (this.authorLastFirstAnds[n] != null) {
            return this.authorLastFirstAnds[n];
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.size() > 0) {
            stringBuffer.append(this.getAuthor(0).getLastFirst(bl));
            for (int i = 1; i < this.size(); ++i) {
                stringBuffer.append(" and ");
                stringBuffer.append(this.getAuthor(i).getLastFirst(bl));
            }
        }
        this.authorLastFirstAnds[n] = stringBuffer.toString();
        return this.authorLastFirstAnds[n];
    }

    public String getAuthorsFirstFirst(boolean bl, boolean bl2) {
        int n = bl ? 0 : 1;
        if (this.authorsFirstFirst[n += bl2 ? 0 : 2] != null) {
            return this.authorsFirstFirst[n];
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.size() > 0) {
            int n2;
            stringBuffer.append(this.getAuthor(0).getFirstLast(bl));
            for (n2 = 1; n2 < this.size() - 1; ++n2) {
                stringBuffer.append(", ");
                stringBuffer.append(this.getAuthor(n2).getFirstLast(bl));
            }
            if (this.size() > 2 && bl2) {
                stringBuffer.append(",");
            }
            if (this.size() > 1) {
                stringBuffer.append(" and ");
                stringBuffer.append(this.getAuthor(n2).getFirstLast(bl));
            }
        }
        this.authorsFirstFirst[n] = stringBuffer.toString();
        return this.authorsFirstFirst[n];
    }

    public String getAuthorsFirstFirstAnds() {
        if (this.authorsFirstFirstAnds != null) {
            return this.authorsFirstFirstAnds;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.size() > 0) {
            stringBuffer.append(this.getAuthor(0).getFirstLast(false));
            for (int i = 1; i < this.size(); ++i) {
                stringBuffer.append(" and ");
                stringBuffer.append(this.getAuthor(i).getFirstLast(false));
            }
        }
        this.authorsFirstFirstAnds = stringBuffer.toString();
        return this.authorsFirstFirstAnds;
    }

    public String getAuthorsForAlphabetization() {
        if (this.authorsAlph != null) {
            return this.authorsAlph;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.size() > 0) {
            stringBuffer.append(this.getAuthor(0).getNameForAlphabetization());
            for (int i = 1; i < this.size(); ++i) {
                stringBuffer.append(" and ");
                stringBuffer.append(this.getAuthor(i).getNameForAlphabetization());
            }
        }
        this.authorsAlph = stringBuffer.toString();
        return this.authorsAlph;
    }

    static {
        tex_names.put("aa", "aa");
        tex_names.put("ae", "ae");
        tex_names.put("l", "l");
        tex_names.put("o", "o");
        tex_names.put("oe", "oe");
        tex_names.put("i", "i");
        tex_names.put("AA", "AA");
        tex_names.put("AE", "AE");
        tex_names.put("L", "L");
        tex_names.put("O", "O");
        tex_names.put("OE", "OE");
        tex_names.put("j", "j");
        authorCache = new WeakHashMap();
    }

    public static class Author {
        private final String first_part;
        private final String first_abbr;
        private final String von_part;
        private final String last_part;
        private final String jr_part;

        public Author(String string, String string2, String string3, String string4, String string5) {
            this.first_part = string;
            this.first_abbr = string2;
            this.von_part = string3;
            this.last_part = string4;
            this.jr_part = string5;
        }

        public String getFirst() {
            return this.first_part;
        }

        public String getFirstAbbr() {
            return this.first_abbr;
        }

        public String getVon() {
            return this.von_part;
        }

        public String getLast() {
            return this.last_part;
        }

        public String getJr() {
            return this.jr_part;
        }

        public String getLastOnly() {
            if (this.von_part == null) {
                return this.last_part == null ? "" : this.last_part;
            }
            return this.last_part == null ? this.von_part : this.von_part + " " + this.last_part;
        }

        public String getLastFirst(boolean bl) {
            String string = this.getLastOnly();
            if (this.jr_part != null) {
                string = string + ", " + this.jr_part;
            }
            if (bl) {
                if (this.first_abbr != null) {
                    string = string + ", " + this.first_abbr;
                }
            } else if (this.first_part != null) {
                string = string + ", " + this.first_part;
            }
            return string;
        }

        public String getFirstLast(boolean bl) {
            String string = this.getLastOnly();
            string = bl ? (this.first_abbr == null ? "" : this.first_abbr + " ") + string : (this.first_part == null ? "" : this.first_part + " ") + string;
            if (this.jr_part != null) {
                string = string + ", " + this.jr_part;
            }
            return string;
        }

        public String getNameForAlphabetization() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.last_part != null) {
                stringBuffer.append(this.last_part);
            }
            if (this.jr_part != null) {
                stringBuffer.append(", ");
                stringBuffer.append(this.jr_part);
            }
            if (this.first_abbr != null) {
                stringBuffer.append(", ");
                stringBuffer.append(this.first_abbr);
            }
            while (stringBuffer.length() > 0 && stringBuffer.charAt(0) == '{') {
                stringBuffer.deleteCharAt(0);
            }
            return stringBuffer.toString();
        }
    }
}

