/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.HelpDialog;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.remote.RemoteListener;

public class AdvancedTab
extends JPanel
implements PrefsTab {
    JabRefPreferences _prefs;
    JabRefFrame _frame;
    HelpDialog helpDiag;
    HelpAction remoteHelp;
    JPanel pan = new JPanel();
    JPanel lnf = new JPanel();
    JLabel lab;
    JCheckBox useDefault;
    JCheckBox useRemoteServer;
    JCheckBox useNativeFileDialogOnMac;
    JTextField className;
    JTextField remoteServerPort;
    JButton def1 = new JButton(Globals.lang("Default"));
    JButton def2 = new JButton(Globals.lang("Default"));
    JPanel p1 = new JPanel();
    JPanel p2 = new JPanel();
    String oldLnf = "";
    boolean oldUseDef;
    int oldPort = -1;

    public AdvancedTab(JabRefPreferences jabRefPreferences, HelpDialog helpDialog) {
        JComponent jComponent;
        this._prefs = jabRefPreferences;
        this.remoteHelp = new HelpAction(helpDialog, GUIGlobals.remoteHelp, "Help", GUIGlobals.getIconUrl("helpSmall"));
        this.useDefault = new JCheckBox(Globals.lang("Use other look and feel"));
        this.useRemoteServer = new JCheckBox(Globals.lang("Listen for remote operation on port") + ":");
        this.useNativeFileDialogOnMac = new JCheckBox(Globals.lang("Use native file dialog"));
        this.remoteServerPort = new JTextField();
        final JTextField jTextField = this.className = new JTextField(50);
        this.useDefault.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jTextField.setEnabled(((JCheckBox)changeEvent.getSource()).isSelected());
            }
        });
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:3dlu", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        JPanel jPanel = new JPanel();
        if (!Globals.ON_MAC) {
            defaultFormBuilder.appendSeparator(Globals.lang("Look and feel"));
            jComponent = new JLabel(Globals.lang("Default look and feel") + ": " + (Globals.ON_WIN ? GUIGlobals.windowsDefaultLookAndFeel : GUIGlobals.linuxDefaultLookAndFeel));
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(jPanel);
            defaultFormBuilder.append(jComponent);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(jPanel);
            defaultFormBuilder.append(this.useDefault);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(jPanel);
            JPanel jPanel2 = new JPanel();
            jComponent = new JLabel(Globals.lang("Class name") + ":");
            jPanel2.add(jComponent);
            jPanel2.add(this.className);
            defaultFormBuilder.append(jPanel2);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(jPanel);
            jComponent = new JLabel(Globals.lang("Note that you must specify the fully qualified class name for the look and feel,"));
            defaultFormBuilder.append(jComponent);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(jPanel);
            jComponent = new JLabel(Globals.lang("and the class must be available in your classpath next time you start JabRef."));
            defaultFormBuilder.append(jComponent);
            defaultFormBuilder.nextLine();
        }
        defaultFormBuilder.appendSeparator(Globals.lang("Remote operation"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        jComponent = new JPanel();
        jComponent.add(this.useRemoteServer);
        jComponent.add(this.remoteServerPort);
        jComponent.add(this.remoteHelp.getIconButton());
        defaultFormBuilder.append(jComponent);
        if (Globals.ON_MAC) {
            defaultFormBuilder.nextLine();
            defaultFormBuilder.appendSeparator(Globals.lang("Mac file dialog"));
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(new JPanel());
            defaultFormBuilder.append(this.useNativeFileDialogOnMac);
        }
        jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    public void setValues() {
        this.oldUseDef = this._prefs.getBoolean("useDefaultLookAndFeel");
        this.oldLnf = this._prefs.get("lookAndFeel");
        this.useDefault.setSelected(!this.oldUseDef);
        this.className.setText(this.oldLnf);
        this.className.setEnabled(!this.oldUseDef);
        this.useRemoteServer.setSelected(this._prefs.getBoolean("useRemoteServer"));
        this.oldPort = this._prefs.getInt("remoteServerPort");
        this.remoteServerPort.setText(String.valueOf(this.oldPort));
        this.useNativeFileDialogOnMac.setSelected(Globals.prefs.getBoolean("useNativeFileDialogOnMac"));
    }

    public void storeSettings() {
        this._prefs.putBoolean("useDefaultLookAndFeel", !this.useDefault.isSelected());
        this._prefs.put("lookAndFeel", this.className.getText());
        this._prefs.putBoolean("useNativeFileDialogOnMac", this.useNativeFileDialogOnMac.isSelected());
        try {
            int n = Integer.parseInt(this.remoteServerPort.getText());
            if (n != this.oldPort) {
                this._prefs.putInt("remoteServerPort", n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        this._prefs.putBoolean("useRemoteServer", this.useRemoteServer.isSelected());
        if (this.useRemoteServer.isSelected() && JabRef.remoteListener == null) {
            JabRef.remoteListener = RemoteListener.openRemoteListener(JabRef.ths);
            if (JabRef.remoteListener != null) {
                JabRef.remoteListener.start();
            }
        } else if (!this.useRemoteServer.isSelected() && JabRef.remoteListener != null) {
            JabRef.remoteListener.disable();
            JabRef.remoteListener = null;
        }
        if (this.useDefault.isSelected() == this.oldUseDef || !this.oldLnf.equals(this.className.getText())) {
            JOptionPane.showMessageDialog(null, Globals.lang("You have changed the look and feel setting. You must restart JabRef for this to come into effect."), Globals.lang("Changed look and feel settings"), 2);
        }
    }

    public boolean readyToClose() {
        try {
            Integer.parseInt(this.remoteServerPort.getText());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, Globals.lang("You must enter an integer value in the text field for") + " '" + Globals.lang("Remote server port") + "'", Globals.lang("Remote server port"), 0);
            return false;
        }
    }

    public String getTabName() {
        return Globals.lang("Advanced");
    }
}

