/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.OptionModifiable;
import gnu.dtools.ritopt.Utility;

public abstract class Option
implements OptionModifiable {
    public static final int DEFAULT_HELP_OPTION_SIZE = 22;
    public static final int DEFAULT_HELP_TYPENAME_SIZE = 10;
    public static final int DEFAULT_HELP_DESCRIPTION_SIZE = 48;
    public static final int DEFAULT_HELP_DEPRECATED_SIZE = 3;
    public static final int DEFAULT_MENU_OPTION_SIZE = 15;
    public static final int DEFAULT_MENU_TYPENAME_SIZE = 10;
    public static final int DEFAULT_MENU_DESCRIPTION_SIZE = 48;
    public static final int DEFAULT_MENU_DEPRECATED_SIZE = 3;
    public static final int DEFAULT_FILE_COMPLETE_OPTION_SIZE = 60;
    public static final int DEFAULT_FILE_COMMENT_SIZE = 16;
    private String longOption;
    private char shortOption;
    private String description;
    private boolean deprecated;
    private static int helpOptionSpecificationSize = 22;
    private static int helpTypenameSize = 10;
    private static int helpDescriptionSize = 48;
    private static int helpDeprecatedSize = 3;
    private static int menuOptionSpecificationSize = 15;
    private static int menuTypenameSize = 10;
    private static int menuDescriptionSize = 48;
    private static int menuDeprecatedSize = 3;
    private static int fileCompleteOptionSize = 60;
    private static int fileCommentSize = 16;
    protected boolean invoked;

    public abstract Object getObject();

    public abstract String getStringValue();

    public Option() {
        this.description = "";
    }

    public Option(Option option) {
        this.longOption = option.getLongOption();
        this.shortOption = option.getShortOption();
        this.description = option.getDescription();
        this.deprecated = option.isDeprecated();
    }

    public Option(String string) {
        this.longOption = string;
        this.shortOption = '\u0000';
        this.description = "";
    }

    public Option(char c) {
        this.shortOption = c;
        this.longOption = null;
        this.description = "";
    }

    public Option(String string, char c) {
        this.longOption = string;
        this.shortOption = c;
        this.description = "";
    }

    public void setKey(String string) {
        this.longOption = string;
    }

    public void setKey(char c) {
        this.shortOption = c;
    }

    public void setShortOption(char c) {
        this.setKey(c);
    }

    public void setLongOption(String string) {
        this.setKey(string);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDeprecated(boolean bl) {
        this.deprecated = bl;
    }

    public static void setHelpOptionSpecificationSize(int n) {
        helpOptionSpecificationSize = n;
    }

    public static void setHelpTypenameSize(int n) {
        helpTypenameSize = n;
    }

    public static void setHelpDescriptionSize(int n) {
        helpDescriptionSize = n;
    }

    public static void setHelpDeprecatedSize(int n) {
        helpDeprecatedSize = n;
    }

    public static void setMenuOptionSpecificationSize(int n) {
        menuOptionSpecificationSize = n;
    }

    public static void setMenuTypenameSize(int n) {
        menuTypenameSize = n;
    }

    public static void setMenuDescriptionSize(int n) {
        menuDescriptionSize = n;
    }

    public static void setMenuDeprecatedSize(int n) {
        menuDeprecatedSize = n;
    }

    public static void setFileCompleteOptionSize(int n) {
        fileCompleteOptionSize = n;
    }

    public static void setFileCommentSize(int n) {
        fileCommentSize = n;
    }

    public void setInvoked(boolean bl) {
        this.invoked = bl;
    }

    public void deprecate() {
        this.setDeprecated(true);
    }

    public String getName() {
        return this.longOption;
    }

    public char getShortOption() {
        return this.shortOption;
    }

    public String getLongOption() {
        return this.longOption;
    }

    public String getHelp() {
        return this.getHelpOptionSpecification() + " " + this.getHelpTypeName() + " " + this.getHelpDescription() + " " + this.getHelpDeprecated();
    }

    public String getHelpOptionSpecification() {
        return Utility.expandString((this.shortOption != '\u0000' ? "-" + this.getShortOption() : "  ") + (this.longOption != null && this.shortOption != '\u0000' ? ", " : "  ") + (this.longOption != null ? "--" + this.getLongOption() : ""), helpOptionSpecificationSize);
    }

    public String getHelpTypeName() {
        return Utility.expandString("<" + this.getTypeName() + ">", helpTypenameSize);
    }

    public String getHelpDescription() {
        return Utility.expandString(this.getDescription(), helpDescriptionSize);
    }

    public String getHelpDeprecated() {
        return Utility.expandString(this.isDeprecated() ? "[d]" : "", helpDeprecatedSize);
    }

    public static String getHelpHeader() {
        return Utility.expandString("Option Name", helpOptionSpecificationSize) + " " + Utility.expandString("Type", helpTypenameSize) + " " + Utility.expandString("Description", helpDescriptionSize);
    }

    public String getDescription() {
        return this.description;
    }

    public String getHashKey() {
        return Option.getHashKey(this.longOption, this.shortOption);
    }

    public static String getHashKey(String string) {
        return "," + (string != null ? string : "");
    }

    public static String getHashKey(char c) {
        return "" + (c != '\u0000') + ",";
    }

    public static String getHashKey(String string, char c) {
        return (c == '\u0000' ? "" : "" + c) + (string == null ? "," : "," + string);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isInvoked() {
        return this.invoked;
    }

    public String getOptionFileLine() {
        boolean bl = false;
        String string = "";
        String string2 = "";
        String string3 = this.getStringValue();
        if (this.longOption != null) {
            string2 = string2 + "--" + this.longOption;
        } else if (this.shortOption != '\u0000') {
            string2 = string2 + "-" + this.shortOption;
        }
        if (string2.length() > 0 && Utility.trim(string3).length() >= 0) {
            string2 = string2 + "=" + string3;
        }
        if (string2.length() <= fileCompleteOptionSize) {
            string = string + Utility.expandString(string2, fileCompleteOptionSize);
        } else {
            string = string + "; " + this.description + "\n";
            string = string + string2;
            bl = true;
        }
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer(this.description);
            boolean bl2 = false;
            while (stringBuffer.length() > 0) {
                String string4 = "";
                int n = 0;
                if (bl2) {
                    string4 = string4 + Utility.getSpaces(fileCompleteOptionSize);
                }
                n = stringBuffer.length() >= fileCommentSize ? fileCommentSize : stringBuffer.length();
                string4 = string4 + "; " + stringBuffer.substring(0, n);
                stringBuffer.delete(0, n);
                string = string + string4 + "\n";
                bl2 = true;
            }
            bl = true;
        }
        return string;
    }

    public static int getHelpOptionSpecificationSize() {
        return helpOptionSpecificationSize;
    }

    public static int getHelpTypenameSize() {
        return helpTypenameSize;
    }

    public static int getHelpDescriptionSize() {
        return helpDescriptionSize;
    }

    public static int getHelpDeprecatedSize() {
        return helpDeprecatedSize;
    }

    public static int getMenuOptionSpecificationSize() {
        return menuOptionSpecificationSize;
    }

    public static int getMenuTypenameSize() {
        return menuTypenameSize;
    }

    public static int getMenuDescriptionSize() {
        return menuDescriptionSize;
    }

    public static int getMenuDeprecatedSize() {
        return menuDeprecatedSize;
    }

    public static int getFileCompleteOptionSize() {
        return fileCompleteOptionSize;
    }

    public static int getFileCommentSize() {
        return fileCommentSize;
    }

    public abstract String getTypeName();

    public void action() {
        if (this.deprecated) {
            System.err.print("Warning: ");
            if (this.longOption != null) {
                System.err.print("--" + this.longOption);
            }
            if (this.shortOption != '\u0000' && this.longOption != null) {
                System.err.print(" or ");
            }
            if (this.shortOption != '\u0000') {
                System.err.println("-" + this.shortOption + " is deprecated.");
            }
        }
    }
}

