/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionModificationException;

public class IntOption
extends Option {
    private int value;

    public IntOption() {
        this(0);
    }

    public IntOption(IntOption intOption) {
        super(intOption);
        intOption.value = intOption.getValue();
    }

    public IntOption(int n) {
        this(n, null);
    }

    public IntOption(int n, String string) {
        this(n, string, '\u0000');
    }

    public IntOption(int n, char c) {
        this(n, null, c);
    }

    public IntOption(int n, String string, char c) {
        super(string, c);
        this.value = n;
    }

    public Object getObject() {
        return new Integer(this.value);
    }

    public void modify(String string) throws OptionModificationException {
        try {
            this.value = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OptionModificationException("Error. An integer must be specified, not '" + string + "'.");
        }
    }

    public void setValue(String string) throws OptionModificationException {
        this.modify(string);
    }

    public void setValue(int n) {
        this.value = n;
    }

    public int getValue() {
        return this.value;
    }

    public String getStringValue() {
        return Integer.toString(this.value);
    }

    public String getTypeName() {
        return "INTEGER";
    }

    public String toString() {
        return this.getStringValue();
    }
}

