/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionModificationException;

public class CharOption
extends Option {
    private char value;

    public CharOption() {
        this(' ');
    }

    public CharOption(CharOption charOption) {
        super(charOption);
        charOption.value = charOption.getValue();
    }

    public CharOption(char c) {
        this(c, null);
    }

    public CharOption(char c, String string) {
        this(c, string, '\u0000');
    }

    public CharOption(char c, char c2) {
        this(c, null, c2);
    }

    public CharOption(char c, String string, char c2) {
        super(string, c2);
        this.value = c;
    }

    public Object getObject() {
        return new Character(this.value);
    }

    public void modify(String string) throws OptionModificationException {
        this.value = (char)(string.length() > 0 ? (int)string.charAt(0) : 32);
    }

    public void setValue(String string) throws OptionModificationException {
        this.modify(string);
    }

    public void setValue(char c) {
        this.value = c;
    }

    public char getValue() {
        return this.value;
    }

    public String getStringValue() {
        return "" + this.value;
    }

    public String getTypeName() {
        return "CHAR";
    }

    public String toString() {
        return this.getStringValue();
    }
}

