/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.jfreechart;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTree;
import ca.odell.glazedlists.jfreechart.ValueSegment;

final class TreePair {
    private SimpleTree start = new SimpleTree(GlazedLists.comparableComparator());
    private SimpleTree end = new SimpleTree(GlazedLists.comparableComparator());

    TreePair() {
    }

    public void insert(ValueSegment segment) {
        this.start.addInSortedOrder((byte)1, segment.getStart(), 1);
        this.end.addInSortedOrder((byte)1, segment.getEnd(), 1);
    }

    public void update(ValueSegment previousSegment, ValueSegment newSegment) {
        this.delete(previousSegment);
        this.insert(newSegment);
    }

    public void delete(ValueSegment segment) {
        int startIndex = this.start.indexOfValue(segment.getStart(), true, false, (byte)1);
        int endIndex = this.end.indexOfValue(segment.getEnd(), true, false, (byte)1);
        this.start.remove(startIndex, 1);
        this.end.remove(endIndex, 1);
    }

    public void clear() {
        this.start = new SimpleTree(GlazedLists.comparableComparator());
        this.end = new SimpleTree(GlazedLists.comparableComparator());
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int getCount(Comparable start, Comparable end) {
        int numStartedBeforeSegmentEnd = this.start.indexOfValue(end, true, true, (byte)1);
        int numEndedBeforeSegmentStart = this.end.indexOfValue(start, true, true, (byte)1);
        return numStartedBeforeSegmentEnd - numEndedBeforeSegmentStart;
    }

    public int size() {
        return this.start.size();
    }
}

