/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.jfreechart;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.GroupingList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.Comparator;
import java.util.List;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.PieDataset;

public class EventListPieDataset
extends AbstractDataset
implements PieDataset {
    private final DatasetChangeEvent immutableChangeEvent = new DatasetChangeEvent((Object)this, (Dataset)this);
    private final EventList sourceList;
    private final GroupingList groupingList;
    private final FunctionList keyList;
    private final FunctionList valueList;
    private final ListEventListener datasetEventListener = new DatasetEventListener();

    public EventListPieDataset(EventList source, FunctionList.Function keyFunction, FunctionList.Function valueFunction) {
        this.groupingList = null;
        this.sourceList = source;
        this.keyList = new FunctionList(source, keyFunction);
        this.valueList = new FunctionList(source, valueFunction);
        source.addListEventListener(this.datasetEventListener);
    }

    public EventListPieDataset(EventList source, Comparator groupingComparator, FunctionList.Function keyFunction, FunctionList.Function valueFunction) {
        this.groupingList = new GroupingList(source, groupingComparator);
        this.sourceList = this.groupingList;
        this.keyList = new FunctionList(this.groupingList, keyFunction);
        this.valueList = new FunctionList(this.groupingList, valueFunction);
        this.groupingList.addListEventListener(this.datasetEventListener);
    }

    public Comparable getKey(int index) {
        return (Comparable)this.keyList.get(index);
    }

    public int getIndex(Comparable key) {
        return this.keyList.indexOf(key);
    }

    public List getKeys() {
        return this.keyList;
    }

    public Number getValue(Comparable key) {
        return this.getValue(this.getIndex(key));
    }

    public int getItemCount() {
        return this.keyList.size();
    }

    public Number getValue(int index) {
        return (Number)this.valueList.get(index);
    }

    public void dispose() {
        this.keyList.dispose();
        this.valueList.dispose();
        this.sourceList.removeListEventListener(this.datasetEventListener);
        if (this.groupingList != null) {
            this.groupingList.dispose();
        }
    }

    protected void fireDatasetChanged() {
        this.notifyListeners(this.immutableChangeEvent);
    }

    private class DatasetEventListener
    implements ListEventListener {
        private DatasetEventListener() {
        }

        public void listChanged(ListEvent listChanges) {
            EventListPieDataset.this.fireDatasetChanged();
        }
    }
}

