/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.io;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.io.Bufferlo;
import ca.odell.glazedlists.impl.io.ListEventToBytes;
import ca.odell.glazedlists.impl.pmap.Chunk;
import ca.odell.glazedlists.impl.pmap.PersistentMap;
import ca.odell.glazedlists.io.ByteCoder;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;

public final class FileList
extends TransformedList {
    private File file = null;
    private ByteCoder byteCoder;
    private PersistentMap storage = null;
    private int nextUpdateId = 81;
    private boolean writable = true;

    public FileList(File file, ByteCoder byteCoder) throws IOException {
        super(new BasicEventList());
        Integer key;
        this.file = file;
        this.byteCoder = byteCoder;
        this.storage = new PersistentMap(file);
        TreeMap<Integer, Bufferlo> sequentialUpdates = new TreeMap<Integer, Bufferlo>();
        Iterator k = this.storage.keySet().iterator();
        while (k.hasNext()) {
            key = (Integer)k.next();
            Bufferlo valueBuffer = ((Chunk)this.storage.get(key)).getValue();
            sequentialUpdates.put(key, valueBuffer);
        }
        Iterator u = sequentialUpdates.keySet().iterator();
        while (u.hasNext()) {
            key = (Integer)u.next();
            Bufferlo update = (Bufferlo)sequentialUpdates.get(key);
            ListEventToBytes.toListEvent(update, this, byteCoder);
        }
        if (!sequentialUpdates.isEmpty()) {
            this.nextUpdateId = (Integer)sequentialUpdates.lastKey() + 1;
        }
        this.source.addListEventListener(this);
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void listChanged(ListEvent listChanges) {
        try {
            ListEvent listChangesCopy = listChanges.copy();
            Bufferlo listChangesBytes = ListEventToBytes.toBytes(listChangesCopy, this.byteCoder);
            this.storage.put(new Integer(this.nextUpdateId), new Chunk(listChangesBytes));
            ++this.nextUpdateId;
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
        this.updates.forwardEvent(listChanges);
    }

    public void close() {
        if (this.storage != null) {
            this.storage.close();
        }
        this.storage = null;
        this.writable = false;
    }

    public void dispose() {
        this.close();
        super.dispose();
    }
}

