/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.List;

public class SyncListener
implements ListEventListener {
    private List target;
    private int targetSize;

    public SyncListener(EventList source, List target) {
        this.target = target;
        target.clear();
        target.addAll(source);
        this.targetSize = target.size();
        source.addListEventListener(this);
    }

    public void listChanged(ListEvent listChanges) {
        EventList source = listChanges.getSourceList();
        if (this.target.size() != this.targetSize) {
            throw new IllegalStateException("Synchronize EventList target has been modified");
        }
        while (listChanges.next()) {
            int index = listChanges.getIndex();
            int type = listChanges.getType();
            if (type == 2) {
                this.target.add(index, source.get(index));
                ++this.targetSize;
                continue;
            }
            if (type == 1) {
                this.target.set(index, source.get(index));
                continue;
            }
            if (type != 0) continue;
            this.target.remove(index);
            --this.targetSize;
        }
    }
}

