/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.GroupingList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class GroupingListMultiMap
implements Map,
ListEventListener {
    private final GroupingList groupingList;
    private final FunctionList valueList;
    private final List keyList;
    private Set keySet;
    private final FunctionList.Function keyFunction;
    private final Map delegate;
    private Set entrySet;

    public GroupingListMultiMap(EventList source, FunctionList.Function keyFunction) {
        this.keyFunction = keyFunction;
        this.groupingList = new GroupingList(source, new FunctionComparator(keyFunction));
        this.valueList = new FunctionList(this.groupingList, new ValueListFunction());
        this.valueList.addListEventListener(this);
        this.keyList = new BasicEventList(this.groupingList.size());
        this.delegate = new HashMap(this.groupingList.size());
        Iterator i = this.valueList.iterator();
        while (i.hasNext()) {
            List value = (List)i.next();
            Comparable key = this.key(value);
            this.keyList.add(key);
            this.delegate.put(key, value);
        }
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public Object get(Object x0) {
        Object key = x0;
        return (List)this.delegate.get(key);
    }

    public Object put(Object x0, Object x1) {
        Comparable key = (Comparable)x0;
        List value = (List)x1;
        this.checkKeyValueAgreement(key, value);
        List removed = (List)this.remove(key);
        this.groupingList.add(value);
        return removed;
    }

    public void putAll(Map m) {
        Iterator i = m.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Comparable key = (Comparable)entry.getKey();
            List value = (List)entry.getValue();
            this.checkKeyValueAgreement(key, value);
        }
        i = m.keySet().iterator();
        while (i.hasNext()) {
            this.remove(i.next());
        }
        this.groupingList.addAll(m.values());
    }

    private void checkKeyValueAgreement(Comparable key, Collection value) {
        Iterator i = value.iterator();
        while (i.hasNext()) {
            this.checkKeyValueAgreement(key, i.next());
        }
    }

    private void checkKeyValueAgreement(Comparable key, Object value) {
        Comparable k = this.key(value);
        if (!GlazedListsImpl.equal(key, k)) {
            throw new IllegalArgumentException("The calculated key for the given value (" + k + ") does not match the given key (" + key + ")");
        }
    }

    public void clear() {
        this.groupingList.clear();
    }

    public Object remove(Object x0) {
        Object key = x0;
        int index = this.keyList.indexOf(key);
        return index == -1 ? null : this.groupingList.remove(index);
    }

    public Collection values() {
        return this.groupingList;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public void listChanged(ListEvent listChanges) {
        while (listChanges.next()) {
            int changeIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType == 2) {
                List inserted = (List)listChanges.getSourceList().get(changeIndex);
                Comparable key = this.key(inserted);
                this.keyList.add(changeIndex, key);
                this.delegate.put(key, inserted);
                continue;
            }
            if (changeType != 0) continue;
            Comparable deleted = (Comparable)this.keyList.remove(changeIndex);
            this.delegate.remove(deleted);
        }
    }

    private Comparable key(List values) {
        return this.key(values.get(0));
    }

    private Comparable key(Object value) {
        return (Comparable)this.keyFunction.evaluate(value);
    }

    private final class ValueList
    implements List {
        private final List delegate;
        private final Comparable key;

        public ValueList(List delegate) {
            this.delegate = delegate;
            this.key = GroupingListMultiMap.this.key(delegate.get(0));
        }

        public int size() {
            return this.delegate.size();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        public Iterator iterator() {
            return this.delegate.iterator();
        }

        public Object[] toArray() {
            return this.delegate.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.delegate.toArray(a);
        }

        public boolean add(Object o) {
            GroupingListMultiMap.this.checkKeyValueAgreement(this.key, o);
            return this.delegate.add(o);
        }

        public boolean addAll(Collection c) {
            GroupingListMultiMap.this.checkKeyValueAgreement(this.key, c);
            return this.delegate.addAll(c);
        }

        public boolean addAll(int index, Collection c) {
            GroupingListMultiMap.this.checkKeyValueAgreement(this.key, c);
            return this.delegate.addAll(index, c);
        }

        public void add(int index, Object element) {
            GroupingListMultiMap.this.checkKeyValueAgreement(this.key, element);
            this.delegate.add(index, element);
        }

        public Object set(int index, Object element) {
            GroupingListMultiMap.this.checkKeyValueAgreement(this.key, element);
            return this.delegate.set(index, element);
        }

        public List subList(int fromIndex, int toIndex) {
            return new ValueList(this.delegate.subList(fromIndex, toIndex));
        }

        public ListIterator listIterator() {
            return new ValueListIterator(this.delegate.listIterator());
        }

        public ListIterator listIterator(int index) {
            return new ValueListIterator(this.delegate.listIterator(index));
        }

        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        public boolean containsAll(Collection c) {
            return this.delegate.containsAll(c);
        }

        public boolean removeAll(Collection c) {
            return this.delegate.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            return this.delegate.retainAll(c);
        }

        public void clear() {
            this.delegate.clear();
        }

        public boolean equals(Object o) {
            return ((Object)this.delegate).equals(o);
        }

        public int hashCode() {
            return ((Object)this.delegate).hashCode();
        }

        public Object get(int index) {
            return this.delegate.get(index);
        }

        public Object remove(int index) {
            return this.delegate.remove(index);
        }

        public int indexOf(Object o) {
            return this.delegate.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.delegate.lastIndexOf(o);
        }

        public String toString() {
            return this.delegate.toString();
        }

        private final class ValueListIterator
        implements ListIterator {
            private final ListIterator delegate;

            public ValueListIterator(ListIterator delegate) {
                this.delegate = delegate;
            }

            public void set(Object o) {
                GroupingListMultiMap.this.checkKeyValueAgreement(ValueList.this.key, o);
                this.delegate.set(o);
            }

            public void add(Object o) {
                GroupingListMultiMap.this.checkKeyValueAgreement(ValueList.this.key, o);
                this.delegate.add(o);
            }

            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            public Object next() {
                return this.delegate.next();
            }

            public boolean hasPrevious() {
                return this.delegate.hasPrevious();
            }

            public Object previous() {
                return this.delegate.previous();
            }

            public int nextIndex() {
                return this.delegate.nextIndex();
            }

            public void remove() {
                this.delegate.remove();
            }

            public int previousIndex() {
                return this.delegate.previousIndex();
            }
        }
    }

    private final class ValueListFunction
    implements FunctionList.Function {
        private ValueListFunction() {
        }

        public Object evaluate(Object x0) {
            List sourceValue = (List)x0;
            return new ValueList(sourceValue);
        }
    }

    private final class FunctionComparator
    implements Comparator {
        private final Comparator delegate = GlazedLists.comparableComparator();
        private final FunctionList.Function function;

        FunctionComparator(FunctionList.Function function) {
            if (function == null) {
                throw new IllegalArgumentException("function may not be null");
            }
            this.function = function;
        }

        public int compare(Object o1, Object o2) {
            Comparable c1 = (Comparable)this.function.evaluate(o1);
            Comparable c2 = (Comparable)this.function.evaluate(o2);
            return this.delegate.compare(c1, c2);
        }
    }

    private class KeySetIterator
    implements Iterator {
        private final ListIterator keyIter;

        KeySetIterator(ListIterator keyIter) {
            this.keyIter = keyIter;
        }

        public boolean hasNext() {
            return this.keyIter.hasNext();
        }

        public Object next() {
            return (Comparable)this.keyIter.next();
        }

        public void remove() {
            int index = this.keyIter.previousIndex();
            if (index == -1) {
                throw new IllegalStateException("Cannot remove() without a prior call to next()");
            }
            GroupingListMultiMap.this.groupingList.remove(index);
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public int size() {
            return GroupingListMultiMap.this.keyList.size();
        }

        public Iterator iterator() {
            return new KeySetIterator(GroupingListMultiMap.this.keyList.listIterator());
        }

        public boolean contains(Object o) {
            return GroupingListMultiMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return GroupingListMultiMap.this.remove(o) != null;
        }

        public void clear() {
            GroupingListMultiMap.this.clear();
        }
    }

    private class MultiMapEntry
    implements Map.Entry {
        private final Comparable key;
        private List value;

        MultiMapEntry(Comparable key, List value) {
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            this.value = value;
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object x0) {
            List newValue = (List)x0;
            GroupingListMultiMap.this.checkKeyValueAgreement((Comparable)this.getKey(), newValue);
            ArrayList oldValue = new ArrayList(this.value);
            this.value.addAll(newValue);
            this.value.removeAll(oldValue);
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            boolean keysEqual = GlazedListsImpl.equal(this.getKey(), e.getKey());
            return keysEqual && GlazedListsImpl.equal(this.getValue(), e.getValue());
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ ((Object)this.value).hashCode();
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class EntrySetIterator
    implements Iterator {
        private final ListIterator keyIter;

        EntrySetIterator(ListIterator keyIter) {
            this.keyIter = keyIter;
        }

        public boolean hasNext() {
            return this.keyIter.hasNext();
        }

        public Object next() {
            Comparable key = (Comparable)this.keyIter.next();
            return new MultiMapEntry(key, (List)GroupingListMultiMap.this.get(key));
        }

        public void remove() {
            int index = this.keyIter.previousIndex();
            if (index == -1) {
                throw new IllegalStateException("Cannot remove() without a prior call to next()");
            }
            GroupingListMultiMap.this.groupingList.remove(index);
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public int size() {
            return GroupingListMultiMap.this.keyList.size();
        }

        public Iterator iterator() {
            return new EntrySetIterator(GroupingListMultiMap.this.keyList.listIterator());
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Comparable key = (Comparable)e.getKey();
            List value = (List)e.getValue();
            List mapValue = (List)GroupingListMultiMap.this.get(key);
            return GlazedListsImpl.equal(value, mapValue);
        }

        public boolean remove(Object o) {
            if (!this.contains(o)) {
                return false;
            }
            GroupingListMultiMap.this.remove(((Map.Entry)o).getKey());
            return true;
        }

        public void clear() {
            GroupingListMultiMap.this.clear();
        }
    }
}

