/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.event;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.impl.adt.IdentityMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class SequenceDependenciesEventPublisher
implements ListEventPublisher {
    private int reentrantFireEventCount = 0;
    private Map subjectsToCleanUp = new IdentityHashMap();
    private Map listenersToRelatedSubjects = new IdentityHashMap();
    private int nextToNotify;
    private List subjectAndListeners = Collections.EMPTY_LIST;
    private List subjectsAndListenersForCurrentEvent = null;
    static /* synthetic */ Class class$ca$odell$glazedlists$event$SequenceDependenciesEventPublisher;

    SequenceDependenciesEventPublisher() {
    }

    private List orderSubjectsAndListeners(List subjectsAndListeners) {
        ArrayList result = new ArrayList();
        IdentityMultimap sourceToPairs = new IdentityMultimap();
        IdentityMultimap targetToPairs = new IdentityMultimap();
        IdentityHashMap<Object, Boolean> satisfied = new IdentityHashMap<Object, Boolean>();
        ArrayList<Object> satisfiedToDo = new ArrayList<Object>();
        int size = subjectsAndListeners.size();
        for (int i = 0; i < size; ++i) {
            SubjectAndListener subjectAndListener = (SubjectAndListener)subjectsAndListeners.get(i);
            Object source = subjectAndListener.subject;
            Object target = this.getRelatedSubject(subjectAndListener.listener);
            sourceToPairs.addValue(source, subjectAndListener);
            targetToPairs.addValue(target, subjectAndListener);
            satisfied.remove(target);
            if (targetToPairs.count(source) != 0) continue;
            satisfied.put(source, Boolean.TRUE);
        }
        satisfiedToDo.addAll(satisfied.keySet());
        while (!satisfiedToDo.isEmpty()) {
            Object subject = satisfiedToDo.remove(0);
            List sourceTargets = (List)sourceToPairs.get(subject);
            int targetsSize = sourceTargets.size();
            block2: for (int t = 0; t < targetsSize; ++t) {
                Object sourceTarget = this.getRelatedSubject(((SubjectAndListener)sourceTargets.get(t)).listener);
                List allSourcesForSourceTarget = (List)targetToPairs.get(sourceTarget);
                if (allSourcesForSourceTarget.size() == 0) continue;
                int sourcesSize = allSourcesForSourceTarget.size();
                for (int s = 0; s < sourcesSize; ++s) {
                    SubjectAndListener sourceAndTarget = (SubjectAndListener)allSourcesForSourceTarget.get(s);
                    if (!satisfied.containsKey(sourceAndTarget.subject)) continue block2;
                }
                result.addAll(allSourcesForSourceTarget);
                targetToPairs.remove(sourceTarget);
                satisfiedToDo.add(sourceTarget);
                satisfied.put(sourceTarget, Boolean.TRUE);
            }
        }
        if (!targetToPairs.isEmpty()) {
            throw new IllegalStateException("Listener cycle detected, " + targetToPairs.values());
        }
        return result;
    }

    private Object getRelatedSubject(Object listener) {
        Object subject = this.listenersToRelatedSubjects.get(listener);
        if (subject == null) {
            return listener;
        }
        return subject;
    }

    public synchronized void addListener(Object subject, Object listener, EventFormat eventFormat) {
        List unordered = this.updateListEventListeners(subject, listener, null, eventFormat);
        this.subjectAndListeners = this.orderSubjectsAndListeners(unordered);
    }

    public synchronized void removeListener(Object subject, Object listener) {
        this.subjectAndListeners = this.updateListEventListeners(subject, null, listener, null);
    }

    private List updateListEventListeners(Object subject, Object listenerToAdd, Object listenerToRemove, EventFormat eventFormat) {
        int anticipatedSize = this.subjectAndListeners.size() + (listenerToAdd == null ? -1 : 1);
        ArrayList<SubjectAndListener> result = new ArrayList<SubjectAndListener>(anticipatedSize);
        for (int i = 0; i < this.subjectAndListeners.size(); ++i) {
            SubjectAndListener originalSubjectAndListener = (SubjectAndListener)this.subjectAndListeners.get(i);
            if (originalSubjectAndListener.listener == listenerToRemove && originalSubjectAndListener.subject == subject) {
                listenerToRemove = null;
                continue;
            }
            if (originalSubjectAndListener.eventFormat.isStale(originalSubjectAndListener.subject, originalSubjectAndListener.listener)) continue;
            result.add(originalSubjectAndListener);
        }
        if (listenerToRemove != null) {
            throw new IllegalArgumentException("Cannot remove nonexistent listener " + listenerToRemove);
        }
        if (listenerToAdd != null) {
            result.add(new SubjectAndListener(subject, listenerToAdd, eventFormat));
        }
        return result;
    }

    public void setRelatedListener(Object subject, Object relatedListener) {
        this.addListener(relatedListener, subject, NoOpEventFormat.INSTANCE);
    }

    public void clearRelatedListener(Object subject, Object relatedListener) {
        this.removeListener(relatedListener, subject);
    }

    public void addDependency(EventList dependency, ListEventListener listener) {
    }

    public void removeDependency(EventList dependency, ListEventListener listener) {
    }

    public void setRelatedSubject(Object listener, Object relatedSubject) {
        if (relatedSubject != null) {
            this.listenersToRelatedSubjects.put(listener, relatedSubject);
        } else {
            this.listenersToRelatedSubjects.remove(listener);
        }
    }

    public void clearRelatedSubject(Object listener) {
        this.listenersToRelatedSubjects.remove(listener);
    }

    public List getListeners(Object subject) {
        ArrayList<Object> result = new ArrayList<Object>();
        int size = this.subjectAndListeners.size();
        for (int i = 0; i < size; ++i) {
            SubjectAndListener subjectAndListener = (SubjectAndListener)this.subjectAndListeners.get(i);
            if (subjectAndListener.subject != subject) continue;
            result.add(subjectAndListener.listener);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(Object subject, Object event, EventFormat eventFormat) {
        if (this.reentrantFireEventCount == 0) {
            this.subjectsAndListenersForCurrentEvent = this.subjectAndListeners;
            this.nextToNotify = Integer.MAX_VALUE;
        }
        ++this.reentrantFireEventCount;
        try {
            EventFormat previous = this.subjectsToCleanUp.put(subject, eventFormat);
            if (previous != null) {
                throw new IllegalStateException("Reentrant fireEvent() by \"" + subject + "\"");
            }
            int subjectAndListenersSize = this.subjectsAndListenersForCurrentEvent.size();
            for (int i = 0; i < subjectAndListenersSize; ++i) {
                SubjectAndListener subjectAndListener = (SubjectAndListener)this.subjectsAndListenersForCurrentEvent.get(i);
                if (subjectAndListener.subject != subject) continue;
                if (i < this.nextToNotify) {
                    this.nextToNotify = i;
                }
                subjectAndListener.addPendingEvent(event);
            }
            if (this.reentrantFireEventCount != 1) {
                return;
            }
            RuntimeException toRethrow = null;
            while (true) {
                SubjectAndListener nextToFire = null;
                for (int i = this.nextToNotify; i < subjectAndListenersSize; ++i) {
                    SubjectAndListener subjectAndListener = (SubjectAndListener)this.subjectsAndListenersForCurrentEvent.get(i);
                    if (!subjectAndListener.hasPendingEvent()) continue;
                    nextToFire = subjectAndListener;
                    this.nextToNotify = i + 1;
                    break;
                }
                if (nextToFire == null) break;
                try {
                    nextToFire.firePendingEvent();
                }
                catch (RuntimeException e) {
                    if (toRethrow != null) continue;
                    toRethrow = e;
                }
            }
            Iterator i = this.subjectsToCleanUp.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry subjectAndEventFormat = i.next();
                try {
                    ((EventFormat)subjectAndEventFormat.getValue()).postEvent(subjectAndEventFormat.getKey());
                }
                catch (RuntimeException e) {
                    if (toRethrow != null) continue;
                    toRethrow = e;
                }
            }
            this.subjectsToCleanUp.clear();
            this.subjectsAndListenersForCurrentEvent = null;
            if (toRethrow != null) {
                throw toRethrow;
            }
        }
        finally {
            --this.reentrantFireEventCount;
        }
    }

    private static class SubjectAndListener {
        private final Object subject;
        private final Object listener;
        private final EventFormat eventFormat;
        private Object pendingEvent;
        static final /* synthetic */ boolean $assertionsDisabled;

        public SubjectAndListener(Object subject, Object listener, EventFormat eventFormat) {
            this.subject = subject;
            this.listener = listener;
            this.eventFormat = eventFormat;
        }

        public boolean hasPendingEvent() {
            return this.pendingEvent != null;
        }

        public void addPendingEvent(Object pendingEvent) {
            if (this.pendingEvent != null) {
                throw new IllegalStateException();
            }
            if (pendingEvent == null) {
                throw new IllegalStateException();
            }
            this.pendingEvent = pendingEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void firePendingEvent() {
            if (!$assertionsDisabled && this.pendingEvent == null) {
                throw new AssertionError();
            }
            try {
                this.eventFormat.fire(this.subject, this.pendingEvent, this.listener);
            }
            finally {
                this.pendingEvent = null;
            }
        }

        public String toString() {
            String separator = this.hasPendingEvent() ? ">>>" : "-->";
            return this.subject + separator + this.listener;
        }

        static {
            $assertionsDisabled = !(class$ca$odell$glazedlists$event$SequenceDependenciesEventPublisher == null ? (class$ca$odell$glazedlists$event$SequenceDependenciesEventPublisher = SequenceDependenciesEventPublisher.class$("ca.odell.glazedlists.event.SequenceDependenciesEventPublisher")) : class$ca$odell$glazedlists$event$SequenceDependenciesEventPublisher).desiredAssertionStatus();
        }
    }

    private static class NoOpEventFormat
    implements EventFormat {
        public static final EventFormat INSTANCE = new NoOpEventFormat();

        private NoOpEventFormat() {
        }

        public void fire(Object subject, Object event, Object listener) {
            throw new UnsupportedOperationException();
        }

        public void postEvent(Object subject) {
            throw new UnsupportedOperationException();
        }

        public boolean isStale(Object subject, Object listener) {
            return false;
        }
    }

    public static interface EventFormat {
        public void fire(Object var1, Object var2, Object var3);

        public void postEvent(Object var1);

        public boolean isStale(Object var1, Object var2);
    }
}

