/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.event;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.event.ListEventPublisher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class GraphDependenciesListEventPublisher
implements ListEventPublisher {
    private List dependentListeners = new ArrayList();
    private int changesInProgress = 0;
    private RuntimeException toRethrow = null;
    private List satisfiedEventLists = new ArrayList();
    private List unsatisfiedListeners = new ArrayList();
    private EventList eventCause = null;

    public void addDependency(EventList dependency, ListEventListener listener) {
        DependentListener dependentListener = this.getDependentListener(listener);
        if (dependentListener == null) {
            dependentListener = new DependentListener(listener);
            this.dependentListeners.add(dependentListener);
        }
        dependentListener.getDependencies().add(dependency);
    }

    public void removeDependency(EventList dependency, ListEventListener listener) {
        DependentListener dependentListener = this.getDependentListener(listener);
        if (dependentListener == null) {
            return;
        }
        List dependencies = dependentListener.getDependencies();
        for (int i = 0; i < dependencies.size(); ++i) {
            if (dependencies.get(i) != dependency) continue;
            dependencies.remove(i);
            break;
        }
        if (dependencies.isEmpty()) {
            this.dependentListeners.remove(dependentListener);
        }
    }

    public void setRelatedSubject(Object listener, Object relatedSubject) {
    }

    public void clearRelatedSubject(Object listener) {
    }

    public void setRelatedListener(Object subject, Object relatedListener) {
    }

    public void clearRelatedListener(Object subject, Object relatedListener) {
    }

    private DependentListener getDependentListener(ListEventListener listener) {
        for (int i = 0; i < this.dependentListeners.size(); ++i) {
            DependentListener dependentListener = (DependentListener)this.dependentListeners.get(i);
            if (dependentListener.getListener() != listener) continue;
            return dependentListener;
        }
        return null;
    }

    private DependentListener getDependentListener(Object object) {
        if (object instanceof ListEventListener) {
            return this.getDependentListener((ListEventListener)object);
        }
        return null;
    }

    private boolean listContains(List eventLists, Object goal) {
        for (int i = 0; i < eventLists.size(); ++i) {
            if (eventLists.get(i) != goal) continue;
            return true;
        }
        return false;
    }

    void fireEvent(EventList source, List listeners, List events) {
        if (this.changesInProgress == 0) {
            this.eventCause = source;
        }
        ++this.changesInProgress;
        if (!this.listContains(this.satisfiedEventLists, source)) {
            this.satisfiedEventLists.add(source);
        }
        for (int i = 0; i < listeners.size(); ++i) {
            ListEventListener listener = (ListEventListener)listeners.get(i);
            ListEvent event = (ListEvent)events.get(i);
            if (!this.dependenciesSatisfied(listener)) {
                DependentListener dependentListener = this.getDependentListener(listener);
                dependentListener.addPendingEvent(event);
                this.unsatisfiedListeners.add(dependentListener);
                continue;
            }
            try {
                listener.listChanged(event);
                if (!(listener instanceof EventList)) continue;
                this.satisfiedEventLists.add((EventList)((Object)listener));
                continue;
            }
            catch (RuntimeException newProblem) {
                if (this.toRethrow != null) continue;
                this.toRethrow = newProblem;
            }
        }
        Iterator i = this.unsatisfiedListeners.iterator();
        while (i.hasNext()) {
            DependentListener dependentListener = (DependentListener)i.next();
            if (!this.dependenciesSatisfied(dependentListener)) continue;
            i.remove();
            try {
                dependentListener.firePendingEvents();
                if (!(dependentListener.getListener() instanceof EventList)) continue;
                this.satisfiedEventLists.add((EventList)((Object)dependentListener.getListener()));
            }
            catch (RuntimeException newProblem) {
                if (this.toRethrow != null) continue;
                this.toRethrow = newProblem;
            }
        }
        --this.changesInProgress;
        if (this.changesInProgress == 0) {
            this.eventCause = null;
            this.satisfiedEventLists.clear();
            if (!this.unsatisfiedListeners.isEmpty()) {
                throw new IllegalStateException("Unsatisfied ListEventListeners: " + this.unsatisfiedListeners);
            }
            if (this.toRethrow != null) {
                RuntimeException usersProblem = this.toRethrow;
                this.toRethrow = null;
                throw usersProblem;
            }
        }
    }

    public boolean dependenciesSatisfied(ListEventListener listener) {
        return this.dependenciesSatisfied(this.getDependentListener(listener));
    }

    public boolean dependenciesSatisfied(DependentListener dependentListener) {
        if (dependentListener == null) {
            return true;
        }
        List dependenciesToSatisfy = dependentListener.getDependencies();
        for (int d = 0; d < dependenciesToSatisfy.size(); ++d) {
            DependentListener dependencyListener;
            EventList dependency = (EventList)dependenciesToSatisfy.get(d);
            if (this.listContains(this.satisfiedEventLists, dependency) || (dependencyListener = this.getDependentListener(dependency)) == null || !dependencyListener.dependsOn(this.eventCause)) continue;
            return false;
        }
        return true;
    }

    class DependentListener {
        private ListEventListener listener;
        private List dependencies = new ArrayList();
        private List pendingEvents = new ArrayList();

        public DependentListener(ListEventListener listener) {
            this.listener = listener;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append(this.listener.getClass().getName());
            result.append("\n");
            Iterator i = this.dependencies.iterator();
            while (i.hasNext()) {
                result.append(" > DEPENDS ON > ").append(((EventList)i.next()).getClass().getName()).append("\n");
            }
            return result.toString();
        }

        public List getDependencies() {
            return this.dependencies;
        }

        public ListEventListener getListener() {
            return this.listener;
        }

        public boolean dependsOn(EventList cause) {
            for (int d = 0; d < this.dependencies.size(); ++d) {
                EventList dependency = (EventList)this.dependencies.get(d);
                if (cause == dependency) {
                    return true;
                }
                DependentListener recursive = GraphDependenciesListEventPublisher.this.getDependentListener(dependency);
                if (recursive == null || !recursive.dependsOn(cause)) continue;
                return true;
            }
            return false;
        }

        public void addPendingEvent(ListEvent pendingEvent) {
            this.pendingEvents.add(pendingEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void firePendingEvents() {
            try {
                for (int i = 0; i < this.pendingEvents.size(); ++i) {
                    ListEvent event = (ListEvent)this.pendingEvents.get(i);
                    this.listener.listChanged(event);
                }
            }
            finally {
                this.pendingEvents.clear();
            }
        }
    }
}

