/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTree;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTreeIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public final class SortedList
extends TransformedList {
    private static final byte ALL_COLORS = 1;
    private static final Element EMPTY_ELEMENT;
    public static final int STRICT_SORT_ORDER = 0;
    public static final int AVOID_MOVING_ELEMENTS = 1;
    private SimpleTree unsorted = null;
    private SimpleTree sorted = null;
    private Comparator comparator = null;
    private int mode = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SortedList(EventList source) {
        this(source, GlazedLists.comparableComparator());
    }

    public SortedList(EventList source, Comparator comparator) {
        super(source);
        this.setComparator(comparator);
        source.addListEventListener(this);
    }

    public void setMode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Mode must be either SortedList.STRICT_SORT_ORDER or SortedList.AVOID_MOVING_ELEMENTS");
        }
        if (mode == this.mode) {
            return;
        }
        this.mode = mode;
        if (this.mode == 0) {
            this.setComparator(this.getComparator());
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void listChanged(ListEvent listChanges) {
        if (listChanges.isReordering()) {
            int[] sourceReorder = listChanges.getReorderMap();
            int[] previousIndexToSortedIndex = new int[this.sorted.size()];
            int index = 0;
            SimpleTreeIterator i = new SimpleTreeIterator(this.sorted);
            while (i.hasNext()) {
                i.next();
                Element unsortedNode = (Element)i.value();
                int unsortedIndex = this.unsorted.indexOfNode(unsortedNode, (byte)1);
                previousIndexToSortedIndex[unsortedIndex] = index++;
            }
            int[] newIndexToSortedIndex = new int[this.sorted.size()];
            for (int i2 = 0; i2 < previousIndexToSortedIndex.length; ++i2) {
                newIndexToSortedIndex[i2] = previousIndexToSortedIndex[sourceReorder[i2]];
            }
            Element[] unsortedNodes = new Element[this.unsorted.size()];
            index = 0;
            SimpleTreeIterator i3 = new SimpleTreeIterator(this.unsorted);
            while (i3.hasNext()) {
                Element unsortedNode;
                i3.next();
                unsortedNodes[index] = unsortedNode = i3.node();
                ++index;
            }
            Arrays.sort(unsortedNodes, this.sorted.getComparator());
            int[] reorderMap = new int[this.sorted.size()];
            boolean indexChanged = false;
            index = 0;
            SimpleTreeIterator i4 = new SimpleTreeIterator(this.sorted);
            while (i4.hasNext()) {
                i4.next();
                Element sortedNode = i4.node();
                Element unsortedNode = unsortedNodes[index];
                sortedNode.set(unsortedNode);
                unsortedNode.set(sortedNode);
                int unsortedIndex = this.unsorted.indexOfNode(unsortedNode, (byte)1);
                reorderMap[index] = newIndexToSortedIndex[unsortedIndex];
                indexChanged = indexChanged || index != reorderMap[index];
                ++index;
            }
            if (indexChanged) {
                this.updates.beginEvent();
                this.updates.reorder(reorderMap);
                this.updates.commitEvent();
            }
            return;
        }
        this.updates.beginEvent();
        LinkedList<Element> insertNodes = new LinkedList<Element>();
        ArrayList<Element> updateNodes = new ArrayList<Element>();
        while (listChanges.next()) {
            Element unsortedNode;
            int unsortedIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType == 2) {
                unsortedNode = this.unsorted.add(unsortedIndex, EMPTY_ELEMENT, 1);
                insertNodes.addLast(unsortedNode);
                continue;
            }
            if (changeType == 1) {
                unsortedNode = this.unsorted.get(unsortedIndex);
                Element sortedNode = (Element)unsortedNode.get();
                sortedNode.setSorted(2);
                updateNodes.add(sortedNode);
                continue;
            }
            if (changeType != 0) continue;
            unsortedNode = this.unsorted.get(unsortedIndex);
            this.unsorted.remove(unsortedNode);
            int deleteSortedIndex = this.deleteByUnsortedNode(unsortedNode);
            this.updates.addDelete(deleteSortedIndex);
        }
        Iterator i = updateNodes.iterator();
        while (i.hasNext()) {
            Element sortedNode = (Element)i.next();
            if (sortedNode.getSorted() != 2) continue;
            Element lowerBound = null;
            Element upperBound = null;
            Element firstUnsortedNode = sortedNode;
            for (Element leftNeighbour = sortedNode.previous(); leftNeighbour != null; leftNeighbour = leftNeighbour.previous()) {
                if (leftNeighbour.getSorted() == 0) {
                    lowerBound = leftNeighbour;
                    break;
                }
                firstUnsortedNode = leftNeighbour;
            }
            for (Element rightNeighbour = sortedNode.next(); rightNeighbour != null; rightNeighbour = rightNeighbour.next()) {
                if (rightNeighbour.getSorted() != 0) continue;
                upperBound = rightNeighbour;
                break;
            }
            Comparator nodeComparator = this.sorted.getComparator();
            for (Element current = firstUnsortedNode; current != upperBound; current = current.next()) {
                if (upperBound != null && nodeComparator.compare(current.get(), upperBound.get()) > 0) {
                    current.setSorted(1);
                    continue;
                }
                if (lowerBound != null && nodeComparator.compare(current.get(), lowerBound.get()) < 0) {
                    current.setSorted(1);
                    continue;
                }
                current.setSorted(0);
                lowerBound = current;
            }
        }
        i = updateNodes.iterator();
        while (i.hasNext()) {
            Element sortedNode = (Element)i.next();
            if (!$assertionsDisabled && sortedNode.getSorted() == 2) {
                throw new AssertionError();
            }
            int originalIndex = this.sorted.indexOfNode(sortedNode, (byte)1);
            if (sortedNode.getSorted() == 0) {
                this.updates.addUpdate(originalIndex);
                continue;
            }
            if (this.mode == 1) {
                this.updates.addUpdate(originalIndex);
                continue;
            }
            this.sorted.remove(sortedNode);
            this.updates.addDelete(originalIndex);
            int insertedIndex = this.insertByUnsortedNode((Element)sortedNode.get());
            this.updates.addInsert(insertedIndex);
        }
        while (!insertNodes.isEmpty()) {
            Element insertNode = (Element)insertNodes.removeFirst();
            int insertedIndex = this.insertByUnsortedNode(insertNode);
            this.updates.addInsert(insertedIndex);
        }
        this.updates.commitEvent();
    }

    private int insertByUnsortedNode(Element unsortedNode) {
        Element sortedNode = this.sorted.addInSortedOrder((byte)1, unsortedNode, 1);
        unsortedNode.set(sortedNode);
        return this.sorted.indexOfNode(sortedNode, (byte)1);
    }

    private int deleteByUnsortedNode(Element unsortedNode) {
        Element sortedNode = (Element)unsortedNode.get();
        int sortedIndex = this.sorted.indexOfNode(sortedNode, (byte)1);
        this.sorted.remove(sortedIndex, 1);
        return sortedIndex;
    }

    protected int getSourceIndex(int mutationIndex) {
        Element sortedNode = this.sorted.get(mutationIndex);
        Element unsortedNode = (Element)sortedNode.get();
        return this.unsorted.indexOfNode(unsortedNode, (byte)1);
    }

    protected boolean isWritable() {
        return true;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        SimpleTree previousSorted = this.sorted;
        Comparator treeComparator = null;
        treeComparator = comparator != null ? new ElementComparator(comparator) : new ElementRawOrderComparator();
        this.sorted = new SimpleTree(treeComparator);
        if (previousSorted == null && this.unsorted == null) {
            this.unsorted = new SimpleTree();
            int n = this.source.size();
            for (int i = 0; i < n; ++i) {
                Element unsortedNode = this.unsorted.add(i, EMPTY_ELEMENT, 1);
                this.insertByUnsortedNode(unsortedNode);
            }
            return;
        }
        if (this.source.size() == 0) {
            return;
        }
        SimpleTreeIterator i = new SimpleTreeIterator(this.unsorted);
        while (i.hasNext()) {
            i.next();
            Element unsortedNode = i.node();
            this.insertByUnsortedNode(unsortedNode);
        }
        int[] reorderMap = new int[this.size()];
        int oldSortedIndex = 0;
        SimpleTreeIterator i2 = new SimpleTreeIterator(previousSorted);
        while (i2.hasNext()) {
            i2.next();
            Element oldSortedNode = i2.node();
            Element unsortedNode = (Element)oldSortedNode.get();
            Element newSortedNode = (Element)unsortedNode.get();
            int newSortedIndex = this.sorted.indexOfNode(newSortedNode, (byte)1);
            reorderMap[newSortedIndex] = oldSortedIndex++;
        }
        this.updates.beginEvent();
        this.updates.reorder(reorderMap);
        this.updates.commitEvent();
    }

    public int indexOf(Object object) {
        if (this.mode != 0 || this.comparator == null) {
            return this.source.indexOf(object);
        }
        int index = this.sorted.indexOfValue(object, true, false, (byte)1);
        if (index == -1) {
            return -1;
        }
        while (index < this.size()) {
            Object objectAtIndex = this.get(index);
            if (this.comparator.compare(object, objectAtIndex) != 0) {
                return -1;
            }
            if (GlazedListsImpl.equal(object, objectAtIndex)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        if (this.mode != 0 || this.comparator == null) {
            return this.source.lastIndexOf(object);
        }
        int index = this.sorted.indexOfValue(object, false, false, (byte)1);
        if (index == -1) {
            return -1;
        }
        while (index > -1) {
            Object objectAtIndex = this.get(index);
            if (this.comparator.compare(object, objectAtIndex) != 0) {
                return -1;
            }
            if (GlazedListsImpl.equal(object, objectAtIndex)) {
                return index;
            }
            --index;
        }
        return -1;
    }

    public int sortIndex(Object object) {
        if (this.comparator == null) {
            throw new IllegalStateException("No Comparator exists to perform this operation");
        }
        return this.sorted.indexOfValue(object, true, true, (byte)1);
    }

    public int lastSortIndex(Object object) {
        if (this.comparator == null) {
            throw new IllegalStateException("No Comparator exists to perform this operation");
        }
        return this.sorted.indexOfValue(object, false, true, (byte)1);
    }

    public int indexOfSimulated(Object object) {
        return this.comparator != null ? this.sorted.indexOfValue(object, true, true, (byte)1) : this.size();
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public Iterator iterator() {
        return new SortedListIterator();
    }

    static {
        $assertionsDisabled = !SortedList.class.desiredAssertionStatus();
        EMPTY_ELEMENT = null;
    }

    private class SortedListIterator
    implements Iterator {
        private SimpleTreeIterator treeIterator;

        private SortedListIterator() {
            this.treeIterator = new SimpleTreeIterator(SortedList.this.sorted);
        }

        public boolean hasNext() {
            return this.treeIterator.hasNext();
        }

        public Object next() {
            this.treeIterator.next();
            Element unsortedNode = (Element)this.treeIterator.value();
            return SortedList.this.source.get(SortedList.this.unsorted.indexOfNode(unsortedNode, (byte)1));
        }

        public void remove() {
            int indexToRemove = this.treeIterator.index();
            SortedList.this.source.remove(SortedList.this.getSourceIndex(indexToRemove));
            this.treeIterator = new SimpleTreeIterator(SortedList.this.sorted, indexToRemove, 1);
        }
    }

    private class ElementRawOrderComparator
    implements Comparator {
        private ElementRawOrderComparator() {
        }

        public int compare(Object alpha, Object beta) {
            try {
                Element alphaTreeNode = (Element)alpha;
                Element betaTreeNode = (Element)beta;
                int alphaIndex = SortedList.this.unsorted.indexOfNode(alphaTreeNode, (byte)1);
                int betaIndex = SortedList.this.unsorted.indexOfNode(betaTreeNode, (byte)1);
                return alphaIndex - betaIndex;
            }
            catch (ClassCastException e) {
                System.out.println(alpha.getClass());
                System.out.println(beta.getClass());
                throw e;
            }
        }
    }

    private class ElementComparator
    implements Comparator {
        private Comparator comparator;

        public ElementComparator(Comparator comparator) {
            this.comparator = comparator;
        }

        public int compare(Object alpha, Object beta) {
            int result;
            Object alphaObject = alpha;
            Object betaObject = beta;
            int alphaIndex = -1;
            int betaIndex = -1;
            if (alpha instanceof Element) {
                Element alphaTreeNode = (Element)alpha;
                alphaIndex = SortedList.this.unsorted.indexOfNode(alphaTreeNode, (byte)1);
                alphaObject = SortedList.this.source.get(alphaIndex);
            }
            if (beta instanceof Element) {
                Element betaTreeNode = (Element)beta;
                betaIndex = SortedList.this.unsorted.indexOfNode(betaTreeNode, (byte)1);
                betaObject = SortedList.this.source.get(betaIndex);
            }
            if ((result = this.comparator.compare(alphaObject, betaObject)) != 0) {
                return result;
            }
            if (alphaIndex != -1 && betaIndex != -1) {
                return alphaIndex - betaIndex;
            }
            return 0;
        }
    }
}

