package org.jboss.proxy;


import java.io.*;
import javax.ejb.EJBHome;
import javax.ejb.Handle;
import javax.ejb.EJBObject;
import org.jboss.logging.Logger;

public class ProxyProxy implements Serializable, EJBObject
{
   static Logger log = Logger.getLogger(ProxyProxy.class);
   InvocationHandler handler;
   String[] targetNames;
   
   
   public ProxyProxy( InvocationHandler handler, Class[] targetTypes )
   {
      this.handler = handler;
      targetNames = new String[ targetTypes.length ];
      for (int iter=0; iter<targetTypes.length; iter++)
      {
         targetNames[iter] = targetTypes[iter].getName();
      }
   }

   private Class[] getClasses()
   {
      try
      {
         ClassLoader cl = Thread.currentThread().getContextClassLoader();
         Class[] classes = new Class[targetNames.length];
         for (int iter=0; iter<targetNames.length; iter++)
         {
            classes[iter] = cl.loadClass( targetNames[iter] );
         }
         return classes;
      }
      catch (Exception e)
      {
         log.error("getClasses", e);
         return null;
      }
   }

   public Object readResolve() throws ObjectStreamException
   {
      return Proxy.newProxyInstance( Thread.currentThread().getContextClassLoader(),
         getClasses(), handler );
   }

   public EJBHome getEJBHome() throws java.rmi.RemoteException
   {
      throw new UnsupportedOperationException();
   }

   public Handle getHandle() throws java.rmi.RemoteException
   {
      throw new UnsupportedOperationException();
   }

   public Object getPrimaryKey() throws java.rmi.RemoteException
   {
      throw new UnsupportedOperationException();
   }

   public boolean isIdentical(EJBObject parm1) throws java.rmi.RemoteException
   {
      throw new UnsupportedOperationException();
   }

   public void remove() throws java.rmi.RemoteException, javax.ejb.RemoveException
   {
      throw new UnsupportedOperationException();
   }
   
}
