/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.monitor;

import java.util.Map;
import java.util.Iterator;
import java.util.ArrayList;
import java.net.URL;

import javax.management.MBeanServer;
import javax.management.MBeanRegistration;
import javax.management.ObjectName;
import javax.management.ObjectInstance;
import javax.management.JMException;

import org.jboss.ejb.ContainerFactory;
import org.jboss.ejb.ContainerFactoryMBean;
import org.jboss.ejb.Application;
import org.jboss.ejb.InstanceCache;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.monitor.client.BeanCacheSnapshot;
import org.jboss.util.ServiceMBeanSupport;

/**
 *
 * @see Monitorable
 * @author Simone Bordet (simone.bordet@compaq.com)
 * @version $Revision: 1.1.6.1 $
 */
public class BeanCacheMonitor extends ServiceMBeanSupport
   implements BeanCacheMonitorMBean
{
   // Constants ----------------------------------------------------
   
   // Static -------------------------------------------------------
   
   // Constructors -------------------------------------------------
   public BeanCacheMonitor()
   {}
   
   // Public -------------------------------------------------------
   public String getName()
   {
      return "BeanCacheMonitor";
   }
   // CacheMonitorMBean implementation -----------------------------------
   public BeanCacheSnapshot[] getSnapshots()
   {
      Iterator applications = null;
      // Get map of deployed applications
      try
      {
         applications = (Iterator)server.invoke(new ObjectName(ContainerFactoryMBean.OBJECT_NAME), "getDeployedApplications", new Object[]
         {}, new String[]
         {});
      }
      catch (JMException x)
      {
         log.warn("getDeployedApplications", x);
         return null;
      }
      
      ArrayList cacheSnapshots = new ArrayList();
      
      // For each application, getContainers()
      while (applications.hasNext())
      {
         Application app = (Application)applications.next();
         String name = app.getName();
         
         // Loop on each container of the application
         for (Iterator containers = app.getContainers().iterator(); containers.hasNext();)
         {
            // Get the cache for each container
            InstanceCache cache = null;
            Object container = containers.next();
            if (container instanceof EntityContainer)
            {
               cache = ((EntityContainer)container).getInstanceCache();
            }
            else if (container instanceof StatefulSessionContainer)
            {
               cache = ((StatefulSessionContainer)container).getInstanceCache();
            }
            
            // Take a cache snapshot
            if (cache instanceof Monitorable)
            {
               BeanCacheSnapshot snapshot = new BeanCacheSnapshot();
               snapshot.m_application = name;
               snapshot.m_container = ((Container)container).getBeanMetaData().getEjbName();
               ((Monitorable)cache).sample(snapshot);
               cacheSnapshots.add(snapshot);
            }
         }
      }
      
      return (BeanCacheSnapshot[])cacheSnapshots.toArray(new BeanCacheSnapshot[0]);
   }
   
   // Inner classes -------------------------------------------------
}

