/*
 * Copyright (c) 2000 Peter Antman Tim <peter.antman@tim.se>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.jboss.jms.jndi;

import javax.naming.Context;
import javax.naming.NamingException;
import java.io.Serializable;

/**
 * JMSProviderAdapter.java
 *
 * <p>Created: Wed Nov 29 14:15:07 2000
 * 
 * <p>6/22/01 - hchirino - The queue/topic jndi references are now configed via JMX
 *
 * @author  <a href="mailto:cojonudo14@hotmail.com">Hiram Chirino</a>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 * @version $Revision: 1.1.6.1 $
 */
public interface JMSProviderAdapter
   extends Serializable
{
   Context getInitialContext() throws NamingException;
   void setName(String name);
   String getName();
   void setProviderUrl(String url);
   String getProviderUrl();
   String getQueueFactoryRef();
   String getTopicFactoryRef();
   void setQueueFactoryRef(String newQueueFactoryRef);
   void setTopicFactoryRef(String newTopicFactoryRef);
}
