/*
 * jBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.ejb.plugins;

import java.rmi.RemoteException;

import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.MessageDrivenEnterpriseContext;

/**
 *	<description>
 *      Stolen from StatelessSessionInstancePool
 *	@see <related>
 *	@author Rickard berg (rickard.oberg@telkel.com)
 *      @author Peter Antman (peter.antman@tim.se)
 *    @author <a href="mailto:sacha.labourey@cogito-info.ch">Sacha Labourey</a>
 *	@version $Revision: 1.3.6.3 $
 *
 *  <p><b>Revisions:</b>
 *  <p><b>20010920 Sacha Labourey:</b>
 *  <ul>
 *  <li>- Activate pooling for MDB
 *  </ul>
 */
public class MessageDrivenInstancePool
   extends AbstractInstancePool
{
   // Constants -----------------------------------------------------

   // Attributes ----------------------------------------------------

   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------

   // Public --------------------------------------------------------

   // Z implementation ----------------------------------------------
   public void init()
      throws Exception
   {
      super.init();
      // for MDB, we *do* pool
      this.reclaim = true;
   }

   // Package protected ---------------------------------------------

   // Protected -----------------------------------------------------
   protected EnterpriseContext create(Object instance)
      throws Exception
   {
      return new MessageDrivenEnterpriseContext(instance, getContainer());
   }

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------

}






