/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.lang.reflect.Method;
import java.util.AbstractList;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.proxy.InvocationHandler;
import org.jboss.proxy.Proxy;

public class MBeanProxy
implements InvocationHandler {
    ObjectName name;
    MBeanServer server;

    MBeanProxy(String name) throws MalformedObjectNameException {
        this(new ObjectName(name));
    }

    MBeanProxy(ObjectName name) {
        this.name = name;
        this.server = (MBeanServer)((AbstractList)MBeanServerFactory.findMBeanServer(null)).iterator().next();
    }

    public static Object create(Class intf, String name) throws MalformedObjectNameException {
        return Proxy.newProxyInstance((ClassLoader)intf.getClassLoader(), (Class[])new Class[]{intf}, (InvocationHandler)new MBeanProxy(name));
    }

    public static Object create(Class intf, ObjectName name) {
        return Proxy.newProxyInstance((ClassLoader)intf.getClassLoader(), (Class[])new Class[]{intf}, (InvocationHandler)new MBeanProxy(name));
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args == null) {
            args = new Object[]{};
        }
        Class<?>[] types = method.getParameterTypes();
        String[] sig = new String[types.length];
        int i = 0;
        while (i < types.length) {
            sig[i] = types[i].getName();
            ++i;
        }
        try {
            return this.server.invoke(this.name, method.getName(), args, sig);
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (ReflectionException e) {
            throw e.getTargetException();
        }
    }
}

