/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;
import org.jboss.mq.SpyMessage;

public class SpyStreamMessage
extends SpyMessage
implements StreamMessage,
Cloneable,
Externalizable {
    Vector content;
    int position;
    int offset;
    int size;
    private static final long serialVersionUID = 2490910971426786841L;

    public SpyStreamMessage() {
        this.msgReadOnly = false;
        this.content = new Vector();
        this.position = 0;
        this.size = 0;
        this.offset = 0;
    }

    public void clearBody() throws JMSException {
        this.content = new Vector();
        this.position = 0;
        this.offset = 0;
        this.size = 0;
        super.clearBody();
    }

    public SpyMessage myClone() throws JMSException {
        SpyStreamMessage result = new SpyStreamMessage();
        result.copyProps(this);
        result.content = (Vector)this.content.clone();
        result.position = this.position;
        result.offset = this.offset;
        result.size = this.size;
        return result;
    }

    public boolean readBoolean() throws JMSException {
        if (!this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            ++this.position;
            this.offset = 0;
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.getBoolean((String)value);
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MessageEOFException("");
        }
    }

    public byte readByte() throws JMSException {
        if (!this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            ++this.position;
            this.offset = 0;
            if (value instanceof Byte) {
                return (Byte)value;
            }
            if (value instanceof String) {
                return Byte.parseByte((String)value);
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MessageEOFException("");
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        if (!this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is writeonly");
        }
        try {
            Object myObj = this.content.get(this.position);
            if (!(myObj instanceof byte[])) {
                throw new MessageFormatException("Invalid conversion");
            }
            byte[] obj = (byte[])myObj;
            if (obj.length == 0) {
                ++this.position;
                this.offset = 0;
                return 0;
            }
            if (this.offset >= obj.length) {
                return -1;
            }
            if (obj.length - this.offset < value.length) {
                int i = 0;
                while (i < obj.length) {
                    value[i] = obj[i + this.offset];
                    ++i;
                }
                ++this.position;
                this.offset = 0;
                return obj.length - this.offset;
            }
            int i = 0;
            while (i < value.length) {
                value[i] = obj[i + this.offset];
                ++i;
            }
            this.offset += value.length;
            return value.length;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MessageEOFException("");
        }
    }

    public char readChar() throws JMSException {
        if (!this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            ++this.position;
            this.offset = 0;
            if (value instanceof Character) {
                return ((Character)value).charValue();
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MessageEOFException("");
        }
    }

    public double readDouble() throws JMSException {
        if (!this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            ++this.position;
            this.offset = 0;
            if (value instanceof Float) {
                return ((Float)value).doubleValue();
            }
            if (value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof String) {
                return Double.parseDouble((String)value);
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MessageEOFException("");
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.content = (Vector)in.readObject();
        this.position = in.readInt();
        this.offset = in.readInt();
        this.size = in.readInt();
    }

    public float readFloat() throws JMSException {
        if (!this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            ++this.position;
            this.offset = 0;
            if (value instanceof Float) {
                return ((Float)value).floatValue();
            }
            if (value instanceof String) {
                return Float.parseFloat((String)value);
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MessageEOFException("");
        }
    }

    public int readInt() throws JMSException {
        if (!this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            ++this.position;
            this.offset = 0;
            if (value instanceof Byte) {
                return ((Byte)value).intValue();
            }
            if (value instanceof Short) {
                return ((Short)value).intValue();
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MessageEOFException("");
        }
    }

    public long readLong() throws JMSException {
        if (!this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            ++this.position;
            this.offset = 0;
            if (value instanceof Byte) {
                return ((Byte)value).longValue();
            }
            if (value instanceof Short) {
                return ((Short)value).longValue();
            }
            if (value instanceof Integer) {
                return ((Integer)value).longValue();
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof String) {
                return Long.parseLong((String)value);
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MessageEOFException("");
        }
    }

    public Object readObject() throws JMSException {
        if (!this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            ++this.position;
            this.offset = 0;
            return value;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MessageEOFException("");
        }
    }

    public short readShort() throws JMSException {
        if (!this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            ++this.position;
            this.offset = 0;
            if (value instanceof Byte) {
                return ((Byte)value).shortValue();
            }
            if (value instanceof Short) {
                return (Short)value;
            }
            if (value instanceof String) {
                return Short.parseShort((String)value);
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MessageEOFException("");
        }
    }

    public String readString() throws JMSException {
        if (!this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            ++this.position;
            this.offset = 0;
            if (value instanceof Boolean) {
                return ((Boolean)value).toString();
            }
            if (value instanceof Byte) {
                return ((Byte)value).toString();
            }
            if (value instanceof Short) {
                return ((Short)value).toString();
            }
            if (value instanceof Character) {
                return ((Character)value).toString();
            }
            if (value instanceof Integer) {
                return ((Integer)value).toString();
            }
            if (value instanceof Long) {
                return ((Long)value).toString();
            }
            if (value instanceof Float) {
                return ((Float)value).toString();
            }
            if (value instanceof Double) {
                return ((Double)value).toString();
            }
            if (value instanceof String) {
                return (String)value;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MessageEOFException("");
        }
    }

    public void reset() throws JMSException {
        this.msgReadOnly = true;
        this.position = 0;
        this.size = this.content.size();
        this.offset = 0;
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(new Boolean(value));
    }

    public void writeByte(byte value) throws JMSException {
        if (this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(new Byte(value));
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(value.clone());
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        if (offset + length > value.length) {
            throw new JMSException("Array is too small");
        }
        byte[] temp = new byte[length];
        int i = 0;
        while (i < length) {
            temp[i] = value[i + offset];
            ++i;
        }
        this.content.add(temp);
    }

    public void writeChar(char value) throws JMSException {
        if (this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(new Character(value));
    }

    public void writeDouble(double value) throws JMSException {
        if (this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(new Double(value));
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.content);
        out.writeInt(this.position);
        out.writeInt(this.offset);
        out.writeInt(this.size);
    }

    public void writeFloat(float value) throws JMSException {
        if (this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(new Float(value));
    }

    public void writeInt(int value) throws JMSException {
        if (this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(new Integer(value));
    }

    public void writeLong(long value) throws JMSException {
        if (this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(new Long(value));
    }

    public void writeObject(Object value) throws JMSException {
        if (this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        if (value instanceof Boolean) {
            this.content.add(value);
        } else if (value instanceof Byte) {
            this.content.add(value);
        } else if (value instanceof Short) {
            this.content.add(value);
        } else if (value instanceof Character) {
            this.content.add(value);
        } else if (value instanceof Integer) {
            this.content.add(value);
        } else if (value instanceof Long) {
            this.content.add(value);
        } else if (value instanceof Float) {
            this.content.add(value);
        } else if (value instanceof Double) {
            this.content.add(value);
        } else if (value instanceof String) {
            this.content.add(value);
        } else if (value instanceof byte[]) {
            this.content.add(((byte[])value).clone());
        } else {
            throw new MessageFormatException("Invalid object type");
        }
    }

    public void writeShort(short value) throws JMSException {
        if (this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(new Short(value));
    }

    public void writeString(String value) throws JMSException {
        if (this.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(new String(value));
    }
}

