/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.jboss.mq.GenericConnectionFactory;
import org.jboss.mq.SpyConnection;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.referenceable.ObjectRefAddr;

public class SpyConnectionFactory
implements Serializable,
QueueConnectionFactory,
TopicConnectionFactory,
Referenceable {
    private GenericConnectionFactory factory;

    public SpyConnectionFactory(GenericConnectionFactory factory) {
        this.factory = factory;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        try {
            return new SpyConnection(this.factory);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpyJMSException("createQueueConnection has failed !", e);
        }
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        try {
            if (userName == null || password == null) {
                throw new JMSException("Invalid login or password !");
            }
            return new SpyConnection(userName, password, this.factory);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpyJMSException("createQueueConnection has failed !", e);
        }
    }

    public TopicConnection createTopicConnection() throws JMSException {
        try {
            return new SpyConnection(this.factory);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpyJMSException("createQueueConnection has failed !", e);
        }
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        try {
            if (userName == null || password == null) {
                throw new JMSException("Invalid login or password !");
            }
            return new SpyConnection(userName, password, this.factory);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpyJMSException("createQueueConnection has failed !", e);
        }
    }

    public Reference getReference() throws NamingException {
        return new Reference("org.jboss.mq.SpyConnectionFactory", new ObjectRefAddr("DCF", this.factory), "org.jboss.mq.referenceable.SpyConnectionFactoryObjectFactory", null);
    }
}

