/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management;

import java.security.InvalidParameterException;
import java.util.Arrays;
import management.IpAddress;
import management.JVM;
import management.Node;
import org.jboss.management.JBossJ2EEManagedObject;

public class JBossNode
extends JBossJ2EEManagedObject
implements Node {
    private String hardwareType;
    private IpAddress[] ipAddresses;
    private JVM[] javaVMs;
    private String osType;

    public JBossNode(String string, String string2, String string3, JVM[] jVMArray, IpAddress[] ipAddressArray) {
        super(string);
        this.setHardwareType(string2);
        this.setIpAddresses(ipAddressArray);
        this.setJavaVMs(jVMArray);
        this.setOsType(string3);
    }

    public String getHardwareType() {
        return this.hardwareType;
    }

    public IpAddress[] getIpAddresses() {
        return this.ipAddresses;
    }

    public JVM[] getJavaVMs() {
        return this.javaVMs;
    }

    public String getOsType() {
        return this.osType;
    }

    public void setHardwareType(String string) {
        this.hardwareType = string;
    }

    public void setIpAddresses(IpAddress[] ipAddressArray) {
        if (ipAddressArray == null || ipAddressArray.length == 0) {
            throw new InvalidParameterException("There must always be at least one IpAddress defined");
        }
        this.ipAddresses = ipAddressArray;
    }

    public void setJavaVMs(JVM[] jVMArray) {
        if (jVMArray == null || jVMArray.length == 0) {
            throw new InvalidParameterException("There must always be at least one JavaVM defined");
        }
        this.javaVMs = jVMArray;
    }

    public void setOsType(String string) {
        this.osType = string;
    }

    public String toString() {
        return "JBossNode [ name: " + this.getName() + ", hardware type: " + this.getHardwareType() + ", os type: " + this.getOsType() + ", JVMs: " + Arrays.asList(this.getJavaVMs()) + ", IP addresses: " + this.getIpAddresses() + " ]";
    }
}

