/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import javax.jms.JMSException;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.server.BasicQueue;
import org.jboss.mq.server.JMSServer;

public class PersistentQueue
extends BasicQueue {
    SpyDestination destination;

    public PersistentQueue(JMSServer server, SpyDestination destination) throws JMSException {
        super(server, destination.toString(), null);
        this.destination = destination;
        server.getPersistenceManager().initQueue(destination);
    }

    public void addMessage(SpyMessage mes, Tx txId) throws JMSException {
        mes.setJMSDestination(this.destination);
        if (mes.getJMSDeliveryMode() == 2) {
            this.server.getPersistenceManager().add(mes, txId);
        }
        super.addMessage(mes, txId);
    }

    public void destroy() throws JMSException {
        super.destroy();
        this.server.getPersistenceManager().destroyQueue(this.destination);
    }
}

