/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.DurableSubcriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.Subscription;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.server.BasicQueue;
import org.jboss.mq.server.ClientConsumer;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.JMSServer;
import org.jboss.mq.server.PersistentQueue;

public class JMSTopic
extends JMSDestination {
    HashMap durQueues = new HashMap();
    HashMap tempQueues = new HashMap();

    JMSTopic(SpyDestination dest, ClientConsumer temporary, JMSServer server) throws JMSException {
        super(dest, temporary, server);
    }

    public void acknowledge(AcknowledgementRequest req, Subscription sub, Tx txId) throws JMSException {
        this.getQueue(sub).acknowledge(req, txId);
    }

    public void addMessage(SpyMessage message, Tx txId) throws JMSException {
        long messageId = 0L;
        JMSTopic jMSTopic = this;
        synchronized (jMSTopic) {
            Iterator<Object> iter;
            messageId = this.messageIdCounter++;
            HashMap hashMap = this.durQueues;
            synchronized (hashMap) {
                iter = this.durQueues.keySet().iterator();
                while (iter.hasNext()) {
                    DurableSubcriptionID id = (DurableSubcriptionID)iter.next();
                    PersistentQueue q = (PersistentQueue)this.durQueues.get(id);
                    SpyMessage clone = message.myClone();
                    clone.durableSubscriberID = id;
                    clone.messageId = messageId;
                    q.addMessage(clone, txId);
                }
            }
            hashMap = this.tempQueues;
            synchronized (hashMap) {
                iter = this.tempQueues.values().iterator();
                while (iter.hasNext()) {
                    BasicQueue q = (BasicQueue)iter.next();
                    SpyMessage clone = message.myClone();
                    clone.messageId = messageId;
                    q.addMessage(clone, txId);
                }
            }
        }
    }

    public void addReceiver(Subscription sub) {
        this.getQueue(sub).addReceiver(sub);
    }

    public void addSubscriber(Subscription sub) throws JMSException {
        SpyTopic topic = (SpyTopic)sub.destination;
        DurableSubcriptionID id = topic.getDurableSubscriptionID();
        if (id == null) {
            BasicQueue q = new BasicQueue(this.server, String.valueOf(this.destination.toString()) + "." + sub.dc.getClientID(), sub);
            HashMap hashMap = this.tempQueues;
            synchronized (hashMap) {
                this.tempQueues.put(sub, q);
            }
        }
        PersistentQueue q = null;
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            q = (PersistentQueue)this.durQueues.get(id);
        }
        if (q == null || !q.destination.equals(topic)) {
            this.server.getStateManager().setDurableSubscription(this.server, id, topic);
        }
    }

    public void clientConsumerStopped(ClientConsumer clientConsumer) {
        Iterator iter;
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            iter = this.durQueues.values().iterator();
            while (iter.hasNext()) {
                ((BasicQueue)iter.next()).clientConsumerStopped(clientConsumer);
            }
        }
        hashMap = this.tempQueues;
        synchronized (hashMap) {
            iter = this.tempQueues.values().iterator();
            while (iter.hasNext()) {
                ((BasicQueue)iter.next()).clientConsumerStopped(clientConsumer);
            }
        }
    }

    public void createDurableSubscription(DurableSubcriptionID id) throws JMSException {
        if (this.temporaryDestination != null) {
            throw new JMSException("Not a valid operation on a temporary topic");
        }
        SpyTopic dstopic = new SpyTopic((SpyTopic)this.destination, id);
        PersistentQueue queue = new PersistentQueue(this.server, dstopic);
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            this.durQueues.put(id, queue);
        }
    }

    public void destoryDurableSubscription(DurableSubcriptionID id) throws JMSException {
        BasicQueue queue;
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            this.log.debug((Object)("Destroying durable subscription: " + id));
            queue = (BasicQueue)this.durQueues.remove(id);
        }
        queue.destroy();
    }

    PersistentQueue getDurableSubscription(DurableSubcriptionID id) {
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            PersistentQueue persistentQueue = (PersistentQueue)this.durQueues.get(id);
            Object var4_4 = null;
            return persistentQueue;
        }
    }

    private BasicQueue getQueue(Subscription sub) {
        SpyTopic topic = (SpyTopic)sub.destination;
        DurableSubcriptionID id = topic.getDurableSubscriptionID();
        if (id != null) {
            return this.getDurableSubscription(id);
        }
        HashMap hashMap = this.tempQueues;
        synchronized (hashMap) {
            BasicQueue basicQueue = (BasicQueue)this.tempQueues.get(sub);
            Object var6_6 = null;
            return basicQueue;
        }
    }

    public SpyMessage receive(Subscription sub, boolean wait) throws JMSException {
        return this.getQueue(sub).receive(sub, wait);
    }

    public void removeReceiver(Subscription sub) {
        this.getQueue(sub).removeReceiver(sub);
    }

    public void removeSubscriber(Subscription sub) throws JMSException {
        BasicQueue queue = null;
        SpyTopic topic = (SpyTopic)sub.destination;
        DurableSubcriptionID id = topic.getDurableSubscriptionID();
        if (id == null) {
            HashMap hashMap = this.tempQueues;
            synchronized (hashMap) {
                queue = (BasicQueue)this.tempQueues.remove(sub);
            }
        }
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            queue = (BasicQueue)this.durQueues.get(id);
            if (queue == null) {
                ((ClientConsumer)sub.clientConsumer).removeRemovedSubscription(sub.subscriptionId);
                Object var6_7 = null;
                return;
            }
        }
        queue.removeSubscriber(sub);
    }

    public void restoreMessage(SpyMessage message) {
        JMSTopic jMSTopic = this;
        synchronized (jMSTopic) {
            this.messageIdCounter = Math.max(this.messageIdCounter, message.messageId + 1L);
        }
        if (message.durableSubscriberID == null) {
            this.log.debug((Object)"Trying to restore message with null durableSubscriberID");
        } else {
            ((BasicQueue)this.durQueues.get(message.durableSubscriberID)).restoreMessage(message);
        }
    }
}

