/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import javax.jms.JMSException;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.server.BasicQueue;
import org.jboss.mq.server.ClientConsumer;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.JMSServer;
import org.jboss.mq.server.PersistentQueue;

public class JMSQueue
extends JMSDestination {
    BasicQueue queue;

    JMSQueue(SpyDestination dest, ClientConsumer temporary, JMSServer server) throws JMSException {
        super(dest, temporary, server);
        this.queue = this.temporaryDestination == null ? new PersistentQueue(server, dest) : new BasicQueue(server, dest.toString(), null);
    }

    public void acknowledge(AcknowledgementRequest req, Subscription sub, Tx txId) throws JMSException {
        this.queue.acknowledge(req, txId);
    }

    public void addMessage(SpyMessage mes, Tx txId) throws JMSException {
        JMSQueue jMSQueue = this;
        synchronized (jMSQueue) {
            mes.messageId = this.messageIdCounter++;
            this.queue.addMessage(mes, txId);
        }
    }

    public void addReceiver(Subscription sub) {
        this.queue.addReceiver(sub);
    }

    public void addSubscriber(Subscription sub) {
    }

    public SpyMessage[] browse(String selector) throws JMSException {
        return this.queue.browse(selector);
    }

    public void clientConsumerStopped(ClientConsumer clientConsumer) {
        this.queue.clientConsumerStopped(clientConsumer);
    }

    public SpyMessage receive(Subscription sub, boolean wait) throws JMSException {
        return this.queue.receive(sub, wait);
    }

    public void removeReceiver(Subscription sub) {
        this.queue.removeReceiver(sub);
    }

    public void removeSubscriber(Subscription sub) {
        this.queue.removeSubscriber(sub);
    }

    public void restoreMessage(SpyMessage message) {
        JMSQueue jMSQueue = this;
        synchronized (jMSQueue) {
            this.messageIdCounter = Math.max(this.messageIdCounter, message.messageId + 1L);
        }
        this.queue.restoreMessage(message);
    }

    public String toString() {
        return "JMSDestination:" + this.destination;
    }
}

