/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.rollinglogged;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.jms.JMSException;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.rollinglogged.IntegrityLog;

public class SpyMessageLog {
    private IntegrityLog transactionLog;

    public SpyMessageLog(String fileName) throws JMSException {
        try {
            this.transactionLog = new IntegrityLog(fileName);
        }
        catch (IOException e) {
            this.throwJMSException("Could not open the queue's tranaction log: " + fileName, e);
        }
    }

    public synchronized void add(SpyMessage message, Tx transactionId) throws JMSException {
        try {
            if (transactionId == null) {
                this.transactionLog.add(message.messageId, false, -1L, message);
            } else {
                this.transactionLog.add(message.messageId, true, transactionId.longValue(), message);
            }
            this.transactionLog.commit();
        }
        catch (IOException e) {
            this.throwJMSException("Could not write to the tranaction log.", e);
        }
    }

    public synchronized void close() throws JMSException {
        try {
            this.transactionLog.close();
        }
        catch (IOException e) {
            this.throwJMSException("Could not close the queue's tranaction log.", e);
        }
    }

    public synchronized void delete() throws JMSException {
        try {
            this.transactionLog.delete();
        }
        catch (IOException e) {
            this.throwJMSException("Could not delete the queue's tranaction log.", e);
        }
    }

    public synchronized void remove(SpyMessage message, Tx transactionId) throws JMSException {
        try {
            if (transactionId == null) {
                this.transactionLog.remove(message.messageId, false, -1L);
            } else {
                this.transactionLog.remove(message.messageId, true, transactionId.longValue());
            }
            this.transactionLog.commit();
        }
        catch (IOException e) {
            this.throwJMSException("Could not write to the queue's tranaction log.", e);
        }
    }

    public synchronized SpyMessage[] restore(TreeSet commited) throws JMSException {
        HashMap messageIndex = new HashMap();
        try {
            LinkedList objects = this.transactionLog.toIndex();
            Iterator it = objects.iterator();
            while (it.hasNext()) {
                Serializable r;
                Object o = it.next();
                if (o instanceof IntegrityLog.MessageAddedRecord) {
                    r = (IntegrityLog.MessageAddedRecord)o;
                    r.message.messageId = r.messageId;
                    if (r.isTransacted && !commited.contains(new Tx(r.transactionId))) continue;
                    messageIndex.put(new Long(r.messageId), o);
                    continue;
                }
                if (!(o instanceof IntegrityLog.MessageRemovedRecord)) continue;
                r = (IntegrityLog.MessageRemovedRecord)o;
                if (((IntegrityLog.MessageRemovedRecord)r).isTransacted && !commited.contains(new Tx(((IntegrityLog.MessageRemovedRecord)r).transactionId))) continue;
                messageIndex.remove(new Long(((IntegrityLog.MessageRemovedRecord)r).messageId));
            }
        }
        catch (Exception e) {
            this.throwJMSException("Could not rebuild the queue from the queue's tranaction log.", e);
        }
        SpyMessage[] rc = new SpyMessage[messageIndex.size()];
        Iterator iter = messageIndex.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            rc[i] = ((IntegrityLog.MessageAddedRecord)iter.next()).message;
            ++i;
        }
        return rc;
    }

    private void throwJMSException(String message, Exception e) throws JMSException {
        SpyJMSException newE = new SpyJMSException(message);
        newE.setLinkedException(e);
        throw newE;
    }

    public String toString() {
        return "SpyMessageLog [ integrity log: " + this.transactionLog + " ]";
    }
}

