/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.logged;

import java.util.TreeSet;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTextMessage;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.logged.SpyMessageLog;
import org.jboss.mq.pm.logged.SpyTxLog;

public class SpyMessageLogTester {
    public static void add(SpyMessageLog log, long messageId, Tx txid) throws Exception {
        SpyTextMessage m = new SpyTextMessage();
        m.messageId = messageId;
        m.setText("Hello World #" + m.messageId);
        System.out.println("Adding message: " + m + ",tx=" + txid);
        log.add(m, txid);
    }

    public static void main(String[] args) throws Exception {
        SpyTxLog tm = new SpyTxLog("SpyTxManager1.dat");
        SpyMessageLog log = new SpyMessageLog("SpyMessageLog1.dat");
        try {
            TreeSet commited = tm.restore();
            SpyMessage[] queue = log.restore(commited);
            System.out.println("Recovered :" + queue.length + " message from the message log");
            long maxMessageId = 0L;
            int i = 0;
            while (i < queue.length) {
                System.out.println("  #" + i + ": " + queue[i]);
                maxMessageId = Math.max(maxMessageId, queue[i].messageId);
                ++i;
            }
            Tx tx1 = tm.createTx();
            ++maxMessageId;
            long first = maxMessageId++;
            SpyMessageLogTester.add(log, first, tx1);
            long second = maxMessageId;
            SpyMessageLogTester.add(log, second, tx1);
            SpyMessageLogTester.remove(log, first, tx1);
            System.out.println("Commiting");
            tm.commitTx(tx1);
            Tx tx2 = tm.createTx();
            SpyMessageLogTester.add(log, first, tx2);
            System.out.println("Rolling back");
            tm.rollbackTx(tx2);
            SpyMessageLogTester.add(log, second + 1L, null);
            System.exit(0);
        }
        finally {
            Object var4_11 = null;
            log.close();
        }
    }

    public static void remove(SpyMessageLog log, long messageId, Tx txid) throws Exception {
        SpyTextMessage m = new SpyTextMessage();
        m.messageId = messageId;
        m.setText("Hello World #" + m.messageId);
        System.out.println("Removing message: " + m + ", tx=" + txid);
        log.remove(m, txid);
    }
}

