/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.logged;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.jms.JMSException;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.logged.ObjectIntegrityLog;

public class SpyMessageLog {
    private ObjectIntegrityLog transactionLog;
    private MessageAddedRecord messageAddedRecord = new MessageAddedRecord();
    private MessageRemovedRecord messageRemovedRecord = new MessageRemovedRecord();

    public SpyMessageLog(String fileName) throws JMSException {
        try {
            this.transactionLog = new ObjectIntegrityLog(fileName);
        }
        catch (IOException e) {
            this.throwJMSException("Could not open the queue's tranaction log: " + fileName, e);
        }
    }

    public synchronized void add(SpyMessage message, Tx transactionId) throws JMSException {
        try {
            this.messageAddedRecord.message = message;
            this.messageAddedRecord.messageId = message.messageId;
            if (transactionId == null) {
                this.messageAddedRecord.isTransacted = false;
            } else {
                this.messageAddedRecord.isTransacted = true;
                this.messageAddedRecord.transactionId = transactionId.longValue();
            }
            this.transactionLog.add(this.messageAddedRecord);
            this.transactionLog.commit();
        }
        catch (IOException e) {
            this.throwJMSException("Could not write to the tranaction log.", e);
        }
    }

    public synchronized void close() throws JMSException {
        try {
            this.transactionLog.close();
        }
        catch (IOException e) {
            this.throwJMSException("Could not close the queue's tranaction log.", e);
        }
    }

    public synchronized void remove(SpyMessage message, Tx transactionId) throws JMSException {
        try {
            this.messageRemovedRecord.messageId = message.messageId;
            if (transactionId == null) {
                this.messageRemovedRecord.isTransacted = false;
            } else {
                this.messageRemovedRecord.isTransacted = true;
                this.messageRemovedRecord.transactionId = transactionId.longValue();
            }
            this.transactionLog.add(this.messageRemovedRecord);
            this.transactionLog.commit();
        }
        catch (IOException e) {
            this.throwJMSException("Could not write to the queue's tranaction log.", e);
        }
    }

    public synchronized SpyMessage[] restore(TreeSet commited) throws JMSException {
        HashMap<Long, ObjectIntegrityLog.IndexItem> messageIndex = new HashMap<Long, ObjectIntegrityLog.IndexItem>();
        try {
            ObjectIntegrityLog.IndexItem[] objects = this.transactionLog.toIndex();
            int i = 0;
            while (i < objects.length) {
                Serializable r;
                Object o = objects[i].record;
                if (o instanceof MessageAddedRecord) {
                    r = (MessageAddedRecord)o;
                    r.message.messageId = r.messageId;
                    if (!r.isTransacted || commited.contains(new Long(r.transactionId))) {
                        messageIndex.put(new Long(r.messageId), objects[i]);
                    }
                } else if (o instanceof MessageRemovedRecord) {
                    r = (MessageRemovedRecord)o;
                    if (!((MessageRemovedRecord)r).isTransacted || commited.contains(new Long(((MessageRemovedRecord)r).transactionId))) {
                        messageIndex.remove(new Long(((MessageRemovedRecord)r).messageId));
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.throwJMSException("Could not rebuild the queue from the queue's tranaction log.", e);
        }
        SpyMessage[] rc = new SpyMessage[messageIndex.size()];
        Iterator iter = messageIndex.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            ObjectIntegrityLog.IndexItem item = (ObjectIntegrityLog.IndexItem)iter.next();
            rc[i] = ((MessageAddedRecord)item.record).message;
            ++i;
        }
        return rc;
    }

    private void throwJMSException(String message, Exception e) throws JMSException {
        SpyJMSException newE = new SpyJMSException(message);
        newE.setLinkedException(e);
        throw newE;
    }

    static class MessageAddedRecord
    implements Serializable {
        long messageId;
        boolean isTransacted;
        long transactionId;
        SpyMessage message;
        private static final long serialVersionUID = 235726945332013954L;

        MessageAddedRecord() {
        }
    }

    static class MessageRemovedRecord
    implements Serializable {
        boolean isTransacted;
        long transactionId;
        long messageId;
        private static final long serialVersionUID = 235726945332013955L;

        MessageRemovedRecord() {
        }
    }
}

