/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.logged;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.jms.JMSException;
import javax.management.ObjectName;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.TxManager;
import org.jboss.mq.pm.logged.PersistenceManagerMBean;
import org.jboss.mq.pm.logged.SpyMessageLog;
import org.jboss.mq.pm.logged.SpyTxLog;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.JMSServer;
import org.jboss.util.ServiceMBeanSupport;

public class PersistenceManager
extends ServiceMBeanSupport
implements PersistenceManagerMBean,
org.jboss.mq.pm.PersistenceManager {
    SpyTxLog spyTxLog;
    HashMap messageLogs = new HashMap();
    URL dataDirURL;
    TxManager txManager = new TxManager(this);
    private String dataDirectory;

    public void add(SpyMessage message, Tx txId) throws JMSException {
        LogInfo logInfo;
        HashMap hashMap = this.messageLogs;
        synchronized (hashMap) {
            logInfo = (LogInfo)this.messageLogs.get(String.valueOf(String.valueOf(message.getJMSDestination())));
        }
        if (logInfo == null) {
            throw new JMSException("Destination was not initalized with the PersistenceManager");
        }
        logInfo.log.add(message, txId);
    }

    public void commitPersistentTx(Tx txId) throws JMSException {
        this.spyTxLog.commitTx(txId);
    }

    public Tx createPersistentTx() throws JMSException {
        return this.spyTxLog.createTx();
    }

    /*
     * WARNING - void declaration
     */
    public void destroyQueue(SpyDestination dest) throws JMSException {
        try {
            URL logFile = new URL(this.dataDirURL, String.valueOf(dest.toString()) + ".dat");
            File file = new File(logFile.getFile());
            SpyMessageLog log = (SpyMessageLog)this.messageLogs.remove(String.valueOf(String.valueOf(dest)));
            if (log == null) {
                throw new SpyJMSException("The persistence log was never initialized");
            }
            log.close();
            file.delete();
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            void file;
            JMSException newE = new JMSException("Invalid configuration.");
            newE.setLinkedException(e);
            throw file;
        }
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public String getName() {
        return "JBossMQ-PersistenceManager";
    }

    public TxManager getTxManager() {
        return this.txManager;
    }

    /*
     * WARNING - void declaration
     */
    public void initQueue(SpyDestination dest) throws JMSException {
        try {
            URL logFile = new URL(this.dataDirURL, String.valueOf(dest.toString()) + ".dat");
            SpyMessageLog log = new SpyMessageLog(logFile.getFile());
            LogInfo info = new LogInfo(log, dest);
            this.messageLogs.put(String.valueOf(String.valueOf(dest)), info);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            void log;
            JMSException newE = new JMSException("Invalid configuration.");
            newE.setLinkedException(e);
            throw log;
        }
    }

    public void initService() throws Exception {
        URL configFile = this.getClass().getClassLoader().getResource("jboss.jcml");
        this.dataDirURL = new URL(configFile, this.dataDirectory);
        URL txLogFile = new URL(this.dataDirURL, "transactions.dat");
        this.spyTxLog = new SpyTxLog(txLogFile.getFile());
        JMSServer server = (JMSServer)this.getServer().invoke(new ObjectName("JBossMQ:service=Server"), "getJMSServer", new Object[0], new String[0]);
        server.setPersistenceManager(this);
    }

    public void remove(SpyMessage message, Tx txId) throws JMSException {
        LogInfo logInfo;
        HashMap hashMap = this.messageLogs;
        synchronized (hashMap) {
            logInfo = (LogInfo)this.messageLogs.get(String.valueOf(String.valueOf(message.getJMSDestination())));
        }
        if (logInfo == null) {
            throw new JMSException("Destination was not initalized with the PersistenceManager");
        }
        logInfo.log.remove(message, txId);
    }

    public void restore(JMSServer server) throws JMSException {
        HashMap clone;
        TreeSet commitedTXs = this.spyTxLog.restore();
        HashMap hashMap = this.messageLogs;
        synchronized (hashMap) {
            clone = (HashMap)this.messageLogs.clone();
        }
        Iterator iter = clone.values().iterator();
        while (iter.hasNext()) {
            LogInfo logInfo = (LogInfo)iter.next();
            JMSDestination q = server.getJMSDestination(logInfo.destination);
            SpyMessage[] rebuild = logInfo.log.restore(commitedTXs);
            JMSDestination jMSDestination = q;
            synchronized (jMSDestination) {
                int i = 0;
                while (i < rebuild.length) {
                    q.restoreMessage(rebuild[i]);
                    ++i;
                }
            }
        }
    }

    public void rollbackPersistentTx(Tx txId) throws JMSException {
        this.spyTxLog.rollbackTx(txId);
    }

    public void setDataDirectory(String newDataDirectory) {
        this.dataDirectory = newDataDirectory;
    }

    public void startService() throws Exception {
        JMSServer server = (JMSServer)this.getServer().invoke(new ObjectName("JBossMQ:service=Server"), "getJMSServer", new Object[0], new String[0]);
        this.restore(server);
    }

    static class LogInfo {
        SpyMessageLog log;
        SpyDestination destination;

        LogInfo(SpyMessageLog log, SpyDestination destination) {
            this.log = log;
            this.destination = destination;
        }
    }
}

