/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil.multiplexor;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.jboss.mq.il.uil.multiplexor.MuxOutputStream;

public class StreamMux {
    short frameSize = (short)512;
    HashMap openStreams = new HashMap();
    OutputStream out;
    DataOutputStream objectOut;
    static final byte OPEN_STREAM_COMMAND = 0;
    static final byte CLOSE_STREAM_COMMAND = 1;
    static final byte NEXT_FRAME_SHORT_COMMAND = 2;

    public StreamMux(OutputStream out) throws IOException {
        this.out = out;
        this.objectOut = new DataOutputStream(out);
    }

    void closeStream(short id) throws IOException {
        if (id == 0) {
            throw new IOException("Stream id 0 is reserved for internal use.");
        }
        Object object = this.openStreams;
        synchronized (object) {
            MuxOutputStream s = (MuxOutputStream)this.openStreams.remove(new Short(id));
        }
        object = this.objectOut;
        synchronized (object) {
            this.objectOut.writeShort(0);
            this.objectOut.writeByte(1);
            this.objectOut.writeShort(id);
        }
    }

    public void flush() throws IOException {
        DataOutputStream dataOutputStream = this.objectOut;
        synchronized (dataOutputStream) {
            this.objectOut.flush();
            this.out.flush();
        }
    }

    public short getFrameSize() {
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            short s = this.frameSize;
            Object var3_3 = null;
            return s;
        }
    }

    public OutputStream getStream(short id) throws IOException {
        OutputStream s;
        if (id == 0) {
            throw new IOException("Stream id 0 is reserved for internal use.");
        }
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            s = (OutputStream)this.openStreams.get(new Short(id));
            if (s != null) {
                OutputStream outputStream = s;
                Object var5_6 = null;
                return outputStream;
            }
            s = new MuxOutputStream(this, id);
            this.openStreams.put(new Short(id), s);
        }
        DataOutputStream dataOutputStream = this.objectOut;
        synchronized (dataOutputStream) {
            this.objectOut.writeShort(0);
            this.objectOut.writeByte(0);
            this.objectOut.writeShort(id);
        }
        return s;
    }

    public void setFrameSize(short newFrameSize) throws IOException {
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            if (this.openStreams.size() > 0) {
                throw new IOException("Cannot change the frame size while there are open streams.");
            }
            this.frameSize = newFrameSize;
        }
    }

    void write(MuxOutputStream s, byte[] b, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (len < 0 || len > b.length || len > this.frameSize) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        DataOutputStream dataOutputStream = this.objectOut;
        synchronized (dataOutputStream) {
            if (len < this.frameSize) {
                this.objectOut.writeShort(0);
                this.objectOut.writeByte(2);
                this.objectOut.writeShort(len);
            }
            this.objectOut.writeShort(s.streamId);
            this.objectOut.write(b, 0, len);
        }
    }
}

