/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import org.jboss.logging.Logger;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.il.ClientIL;
import org.jboss.mq.il.uil.multiplexor.SocketMultiplexor;

public class UILClientIL
implements ClientIL,
Serializable {
    static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$il$uil$UILClientIL != null ? class$org$jboss$mq$il$uil$UILClientIL : (class$org$jboss$mq$il$uil$UILClientIL = UILClientIL.class$("org.jboss.mq.il.uil.UILClientIL"))));
    transient SocketMultiplexor mSocket;
    private transient ObjectInputStream in;
    private transient ObjectOutputStream out;
    static final int m_close = 2;
    static final int m_deleteTemporaryDestination = 1;
    static final int m_receive = 3;
    static final int m_pong = 4;
    static /* synthetic */ Class class$org$jboss$mq$il$uil$UILClientIL;

    protected void checkSocket() throws Exception {
        if (this.out == null) {
            this.createConnection();
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void close() throws Exception {
    }

    protected void createConnection() throws RemoteException {
        try {
            this.in = new ObjectInputStream(new BufferedInputStream(this.mSocket.getInputStream(2)));
            this.out = new ObjectOutputStream(new BufferedOutputStream(this.mSocket.getOutputStream(2)));
            this.out.flush();
        }
        catch (Exception exception) {
            throw new RemoteException("Cannot connect to the ConnectionReceiver/Server");
        }
    }

    public synchronized void deleteTemporaryDestination(SpyDestination dest) throws Exception {
        this.checkSocket();
        this.out.writeByte(1);
        this.out.writeObject(dest);
        this.waitAnswer();
    }

    public synchronized void pong(long serverTime) throws Exception {
        this.checkSocket();
        this.out.writeByte(4);
        this.out.writeLong(serverTime);
        this.waitAnswer();
    }

    public synchronized void receive(ReceiveRequest[] messages) throws Exception {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Checking socket");
        }
        this.checkSocket();
        if (trace) {
            log.trace((Object)"Writing request");
        }
        this.out.writeByte(3);
        this.out.writeInt(messages.length);
        int i = 0;
        while (i < messages.length) {
            messages[i].writeExternal(this.out);
            ++i;
        }
        if (trace) {
            log.trace((Object)"Waiting for awnser");
        }
        this.waitAnswer();
        if (trace) {
            log.trace((Object)"Done");
        }
    }

    protected void waitAnswer() throws Exception {
        block6: {
            RemoteException throwException = null;
            try {
                this.out.reset();
                this.out.flush();
                byte val = this.in.readByte();
                switch (val) {
                    case 1: {
                        Exception e = (Exception)this.in.readObject();
                        throwException = new RemoteException("", e);
                        break;
                    }
                    default: {
                        if (throwException == null) break block6;
                    }
                }
            }
            catch (IOException e) {
                throw new RemoteException("Cannot contact the remote object", e);
            }
            if (throwException == null) break block6;
            throw throwException;
        }
    }
}

