/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.cluster.jms;

import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.cluster.jms.ClusterTopicSession;

public class ClusterTopicPublisher
implements TopicPublisher {
    protected int defaultDeliveryMode = 2;
    protected int defaultPriority = 4;
    protected long defaultTTL = 0L;
    private boolean disableMessageID = false;
    private boolean disableTS = false;
    private ClusterTopicSession session;
    private Topic myTopic = null;

    ClusterTopicPublisher(ClusterTopicSession s, Topic t) {
        this.session = s;
        this.myTopic = t;
    }

    public void close() throws JMSException {
    }

    public int getDeliveryMode() throws JMSException {
        return this.defaultDeliveryMode;
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.disableMessageID;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.disableTS;
    }

    public int getPriority() throws JMSException {
        return this.defaultPriority;
    }

    public long getTimeToLive() throws JMSException {
        return this.defaultTTL;
    }

    public Topic getTopic() throws JMSException {
        return this.myTopic;
    }

    public void publish(Message message) throws JMSException {
        if (this.myTopic == null) {
            throw new InvalidDestinationException("I do not have a default Destination !");
        }
        this.publish(this.myTopic, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTTL);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.myTopic == null) {
            throw new InvalidDestinationException("Destination is null !");
        }
        this.publish(this.myTopic, message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.publish(topic, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTTL);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        message.setJMSDestination((Destination)topic);
        message.setJMSDeliveryMode(deliveryMode);
        long ts = System.currentTimeMillis();
        message.setJMSTimestamp(ts);
        if (timeToLive == 0L) {
            message.setJMSExpiration(0L);
        } else {
            message.setJMSExpiration(timeToLive + ts);
        }
        message.setJMSPriority(priority);
        message.setJMSMessageID(this.session.connection.getNextMessageId());
        SpyMessage clone = ((SpyMessage)message).myClone();
        clone.setReadOnlyMode();
        this.session.connection.send(clone);
    }

    public void setDeliveryMode(int deli) throws JMSException {
        if (deli == 2) {
            this.defaultDeliveryMode = 1;
        } else {
            if (deli != 1 && deli != 2) {
                throw new JMSException("Bad DeliveryMode value");
            }
            this.defaultDeliveryMode = deli;
        }
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.disableMessageID = value;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.disableTS = value;
    }

    public void setPriority(int pri) throws JMSException {
        if (pri == 4) {
            this.defaultPriority = 4;
        } else {
            if (pri < 0 || pri > 9) {
                throw new JMSException("Bad priority value");
            }
            this.defaultPriority = pri;
        }
    }

    public void setTimeToLive(int timeToLive) throws JMSException {
        if ((long)timeToLive == 0L) {
            timeToLive = 0;
        } else {
            if (timeToLive < 0) {
                throw new JMSException("Bad TimeToLive value");
            }
            this.defaultTTL = timeToLive;
        }
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        if (timeToLive == 0L) {
            timeToLive = 0L;
        } else {
            if (timeToLive < 0L) {
                throw new JMSException("Bad TimeToLive value");
            }
            this.defaultTTL = timeToLive;
        }
    }
}

