/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.cluster.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.apache.log4j.Category;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.cluster.jms.ClusterConnectionMetaData;
import org.jboss.mq.cluster.jms.ClusterTemporaryTopic;
import org.jboss.mq.cluster.jms.ClusterTopic;
import org.jboss.mq.cluster.jms.ClusterTopicSession;
import org.jboss.mq.cluster.jms.ClusterTopicSubscriber;
import org.jboss.mq.cluster.transport.NodeId;
import org.jboss.mq.cluster.transport.Transport;
import org.jboss.mq.cluster.transport.TransportListener;
import org.jboss.mq.cluster.transport.udp.UDPTransport;
import org.jboss.mq.xml.XElement;

public class ClusterTopicConnection
implements Serializable,
TopicConnection,
TransportListener {
    public boolean modeStop;
    public HashMap topicSubscribers = new HashMap();
    Transport transport = new UDPTransport();
    boolean closed;
    HashSet createdSessions = new HashSet();
    private ExceptionListener exceptionListener;
    private int lastMessageId;
    private int lastTemporaryTopicId = 0;
    private XElement serverXElement;
    static final short TEMPORARY_TOPIC_ID = 0;
    static Category cat = Category.getInstance((Class)(class$org$jboss$mq$cluster$jms$ClusterTopicConnection != null ? class$org$jboss$mq$cluster$jms$ClusterTopicConnection : (class$org$jboss$mq$cluster$jms$ClusterTopicConnection = ClusterTopicConnection.class$("org.jboss.mq.cluster.jms.ClusterTopicConnection"))));
    static /* synthetic */ Class class$org$jboss$mq$cluster$jms$ClusterTopicConnection;

    public ClusterTopicConnection(XElement config) throws JMSException {
        this.serverXElement = config;
        try {
            Properties connectionProperties = new Properties();
            connectionProperties.setProperty("TransportMode", "Multicast");
            connectionProperties.setProperty("Group", "225.1.1.1");
            connectionProperties.setProperty("Port", "1000");
            this.transport.setProperties(connectionProperties);
            this.transport.setTransportListener(this);
            this.transport.start();
        }
        catch (Exception e) {
            this.failureHandler(e, "Transport protocol could not be initialized");
        }
    }

    void addConsumer(ClusterTopicSubscriber consumer) throws JMSException {
        cat.debug((Object)("[" + this + "]: addConsumer(dest=" + consumer.topic + ")"));
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        HashMap hashMap = this.topicSubscribers;
        synchronized (hashMap) {
            LinkedList ll = (LinkedList)this.topicSubscribers.get(consumer.topic);
            ll = ll == null ? new LinkedList() : (LinkedList)ll.clone();
            ll.add(consumer);
            HashMap t = (HashMap)this.topicSubscribers.clone();
            t.put(consumer.topic, ll);
            this.topicSubscribers = t;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void close() throws JMSException {
        if (this.closed) {
            return;
        }
        cat.debug((Object)("Closing sessions, ClientID=" + this.getClientID()));
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            Object[] vect = ((AbstractCollection)this.createdSessions).toArray();
            int i = 0;
            while (i < vect.length) {
                ((ClusterTopicSession)vect[i]).close();
                ++i;
            }
        }
        cat.debug((Object)"Closed sessions");
        cat.debug((Object)"Disconnecting from the transport");
        try {
            this.transport.stop();
            this.transport.close();
        }
        catch (Exception e) {
            this.failureHandler(e, "Cannot properly close the transport");
        }
        cat.debug((Object)"Disconnected from the transport");
        this.closed = true;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("This feature is not implemented");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("This feature is not implemented");
    }

    Topic createTopic(String name) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        try {
            Enumeration topics = this.serverXElement.getElementsNamed("Topic");
            while (topics.hasMoreElements()) {
                XElement topic = (XElement)topics.nextElement();
                if (!topic.getField("Name").equals(name)) continue;
                short id = Short.parseShort(topic.getField("TopicId"));
                return new ClusterTopic(id);
            }
            throw new JMSException("This destination does not exist !");
        }
        catch (Exception exception) {
            throw new JMSException("This destination does not exist !");
        }
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        ClusterTopicSession session = new ClusterTopicSession(this);
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            this.createdSessions.add(session);
        }
        return session;
    }

    public void failureHandler(Exception e, String reason) throws JMSException {
        e.printStackTrace();
        JMSException excep = new JMSException(reason);
        excep.setLinkedException(e);
        if (this.exceptionListener != null) {
            ExceptionListener exceptionListener = this.exceptionListener;
            synchronized (exceptionListener) {
                this.exceptionListener.onException(excep);
            }
        } else {
            cat.error((Object)e);
        }
        throw excep;
    }

    public String getClientID() {
        return this.transport.getLocalNodeId().toString();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        return this.exceptionListener;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        return new ClusterConnectionMetaData();
    }

    public String getNextMessageId() {
        return "ID:" + this.getClientID() + ++this.lastMessageId;
    }

    TemporaryTopic getTemporaryTopic() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        try {
            return new ClusterTemporaryTopic(this.transport.getLocalNodeId(), this.lastTemporaryTopicId++);
        }
        catch (Exception e) {
            this.failureHandler(e, "Cannot create a temporary topic !");
            return null;
        }
    }

    public boolean isListeningOn(short topic) {
        if (this.modeStop) {
            return false;
        }
        if (topic == 0) {
            return true;
        }
        ClusterTopic t = new ClusterTopic(topic);
        LinkedList ll = (LinkedList)this.topicSubscribers.get(t);
        return ll != null;
    }

    public void messageArrivedEvent(short channelId, NodeId senderId, byte[] message) throws InterruptedException {
        if (this.modeStop) {
            return;
        }
        SpyMessage spyMessage = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(message);
            ObjectInputStream is = new ObjectInputStream(bais);
            spyMessage = (SpyMessage)is.readObject();
        }
        catch (Exception e) {
            try {
                this.failureHandler(e, "Invalid message received.");
            }
            catch (JMSException jMSException) {}
        }
        this.onMessage(senderId, spyMessage);
    }

    private void onMessage(NodeId sender, SpyMessage message) throws InterruptedException {
        if (this.modeStop) {
            return;
        }
        LinkedList ll = (LinkedList)this.topicSubscribers.get(message.getJMSDestination());
        if (ll == null) {
            cat.debug((Object)("No subscriptions for message: " + message));
            return;
        }
        cat.debug((Object)("Dispatching message: " + message));
        Iterator i = ll.iterator();
        while (i.hasNext()) {
            ClusterTopicSubscriber c = (ClusterTopicSubscriber)i.next();
            c.onMessage(sender, message);
        }
    }

    public void send(SpyMessage message) throws JMSException {
        try {
            short topic;
            NodeId dest = null;
            Destination o = message.getJMSDestination();
            if (o instanceof ClusterTemporaryTopic) {
                topic = 0;
                dest = ((ClusterTemporaryTopic)o).nodeId;
                if (dest.equals(this.transport.getLocalNodeId())) {
                    this.onMessage(this.transport.getLocalNodeId(), message);
                    return;
                }
            } else {
                topic = ((ClusterTopic)o).topicId;
                this.onMessage(this.transport.getLocalNodeId(), message);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(message);
            os.close();
            byte[] data = bos.toByteArray();
            if (dest == null) {
                this.transport.send(topic, data, false, true);
            } else {
                this.transport.send(dest, topic, data, false, true);
            }
        }
        catch (Exception e) {
            this.failureHandler(e, "Could not send the message to the cluster");
        }
    }

    void sessionClosing(ClusterTopicSession who) {
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            this.createdSessions.remove(who);
        }
    }

    public void setClientID(String arg1) throws JMSException {
        throw new JMSException("The client Id cannot be changed");
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.exceptionListener = listener;
    }

    public void start() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (!this.modeStop) {
            return;
        }
        this.modeStop = false;
    }

    public void stop() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (this.modeStop) {
            return;
        }
        this.modeStop = true;
    }
}

