/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.jboss.mq.SpyEncapsulatedMessage;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyMessageProducer;
import org.jboss.mq.SpyTopicSession;

public class SpyTopicPublisher
extends SpyMessageProducer
implements TopicPublisher {
    private SpyTopicSession mySession;
    private Topic myTopic = null;

    SpyTopicPublisher(SpyTopicSession s, Topic t) {
        this.mySession = s;
        this.myTopic = t;
        try {
            if (t instanceof TemporaryTopic) {
                this.setDeliveryMode(1);
            } else {
                this.setDeliveryMode(2);
            }
        }
        catch (JMSException jMSException) {}
    }

    public Topic getTopic() throws JMSException {
        return this.myTopic;
    }

    public void publish(Message message) throws JMSException {
        if (this.myTopic == null) {
            throw new InvalidDestinationException("I do not have a default Destination !");
        }
        this.publish(this.myTopic, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTTL);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.myTopic == null) {
            throw new InvalidDestinationException("Destination is null !");
        }
        this.publish(this.myTopic, message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.publish(topic, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTTL);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        message.setJMSDestination((Destination)topic);
        message.setJMSDeliveryMode(deliveryMode);
        long ts = System.currentTimeMillis();
        message.setJMSTimestamp(ts);
        if (timeToLive == 0L) {
            message.setJMSExpiration(0L);
        } else {
            message.setJMSExpiration(timeToLive + ts);
        }
        message.setJMSPriority(priority);
        message.setJMSMessageID(this.mySession.getNewMessageID());
        if (!(message instanceof SpyMessage)) {
            SpyEncapsulatedMessage m = new SpyEncapsulatedMessage();
            m.setMessage(message);
            message = m;
        }
        SpyMessage clone = ((SpyMessage)message).myClone();
        clone.setReadOnlyMode();
        this.mySession.sendMessage(clone);
    }
}

