/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedVariable;

public class SynchronizedLong
extends SynchronizedVariable
implements Comparable,
Cloneable {
    protected long value_;

    public SynchronizedLong(long initialValue) {
        this.value_ = initialValue;
    }

    public SynchronizedLong(long initialValue, Object lock) {
        super(lock);
        this.value_ = initialValue;
    }

    public final long get() {
        Object object = this.lock_;
        synchronized (object) {
            long l = this.value_;
            return l;
        }
    }

    public long set(long newValue) {
        Object object = this.lock_;
        synchronized (object) {
            long old = this.value_;
            this.value_ = newValue;
            long l = old;
            return l;
        }
    }

    public boolean commit(long assumedValue, long newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean success;
            boolean bl = success = assumedValue == this.value_;
            if (success) {
                this.value_ = newValue;
            }
            boolean bl2 = success;
            return bl2;
        }
    }

    public long swap(SynchronizedLong other) {
        if (other != this) {
            SynchronizedLong fst = this;
            SynchronizedLong snd = other;
            if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
                fst = other;
                snd = this;
            }
            Object object = fst.lock_;
            synchronized (object) {
                Object object2 = snd.lock_;
                synchronized (object2) {
                    fst.set(snd.set(fst.get()));
                }
            }
        }
        return this.value_;
    }

    public long increment() {
        Object object = this.lock_;
        synchronized (object) {
            long l = ++this.value_;
            return l;
        }
    }

    public long decrement() {
        Object object = this.lock_;
        synchronized (object) {
            long l = --this.value_;
            return l;
        }
    }

    public long add(long amount) {
        Object object = this.lock_;
        synchronized (object) {
            long l = this.value_ += amount;
            return l;
        }
    }

    public long subtract(long amount) {
        Object object = this.lock_;
        synchronized (object) {
            long l = this.value_ -= amount;
            return l;
        }
    }

    public synchronized long multiply(long factor) {
        Object object = this.lock_;
        synchronized (object) {
            long l = this.value_ *= factor;
            return l;
        }
    }

    public long divide(long factor) {
        Object object = this.lock_;
        synchronized (object) {
            long l = this.value_ /= factor;
            return l;
        }
    }

    public long negate() {
        Object object = this.lock_;
        synchronized (object) {
            long l = this.value_ = -this.value_;
            return l;
        }
    }

    public long complement() {
        Object object = this.lock_;
        synchronized (object) {
            this.value_ ^= 0xFFFFFFFFFFFFFFFFL;
            long l = this.value_;
            return l;
        }
    }

    public long and(long b) {
        Object object = this.lock_;
        synchronized (object) {
            this.value_ &= b;
            long l = this.value_;
            return l;
        }
    }

    public long or(long b) {
        Object object = this.lock_;
        synchronized (object) {
            this.value_ |= b;
            long l = this.value_;
            return l;
        }
    }

    public long xor(long b) {
        Object object = this.lock_;
        synchronized (object) {
            this.value_ ^= b;
            long l = this.value_;
            return l;
        }
    }

    public int compareTo(long other) {
        long val = this.get();
        return val < other ? -1 : (val == other ? 0 : 1);
    }

    public int compareTo(SynchronizedLong other) {
        return this.compareTo(other.get());
    }

    public int compareTo(Object other) {
        return this.compareTo((SynchronizedLong)other);
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof SynchronizedLong) {
            return this.get() == ((SynchronizedLong)other).get();
        }
        return false;
    }

    public int hashCode() {
        long v = this.get();
        return (int)(v ^ v >> 32);
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

