/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.verifier.factory;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import org.jboss.verifier.Section;
import org.jboss.verifier.event.VerificationEvent;
import org.jboss.verifier.event.VerificationEventGenerator;
import org.jboss.verifier.factory.VerificationEventFactory;

public class DefaultEventFactory
implements VerificationEventFactory {
    public static final String MESSAGE_BUNDLE = "/org/jboss/verifier/DefaultMessages.properties";
    private Map msgTable = this.loadErrorMessages();

    public VerificationEvent createBeanVerifiedEvent(VerificationEventGenerator source) {
        VerificationEvent event = new VerificationEvent(source);
        event.setState("OK");
        event.setMessage("Verified.");
        return event;
    }

    public VerificationEvent createSpecViolationEvent(VerificationEventGenerator source, Section section) {
        VerificationEvent event = new VerificationEvent(source);
        event.setState("WARNING");
        event.setSection(section);
        event.setMessage((String)this.msgTable.get(section.getSection()));
        return event;
    }

    private Map loadErrorMessages() {
        try {
            InputStream in = this.getClass().getResourceAsStream(MESSAGE_BUNDLE);
            Properties props = new Properties();
            props.load(in);
            return props;
        }
        catch (IOException e) {
            throw new MissingResourceException("I/O failure: " + e.getMessage(), MESSAGE_BUNDLE, "");
        }
        catch (NullPointerException nullPointerException) {
            throw new MissingResourceException("Resource not found.", MESSAGE_BUNDLE, "");
        }
    }
}

