/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.lindfors.util.support;

import java.util.Enumeration;
import org.gjt.lindfors.util.EventGeneratorSupport;
import org.gjt.lindfors.util.event.BufferEvent;
import org.gjt.lindfors.util.event.BufferEventGenerator;
import org.gjt.lindfors.util.event.BufferListener;

public class BufferEventGeneratorSupport
extends EventGeneratorSupport {
    public void fireElementAdded(BufferEvent bufferEvent) {
        Enumeration enumeration = super.getListeners();
        while (enumeration.hasMoreElements()) {
            BufferListener bufferListener = (BufferListener)enumeration.nextElement();
            bufferListener.elementAdded(bufferEvent);
        }
    }

    public void fireElementAdded(BufferEventGenerator bufferEventGenerator, Object object) {
        this.fireElementAdded(BufferEventGeneratorSupport.createElementAddedEvent(bufferEventGenerator, object));
    }

    public void fireElementRemoved(BufferEvent bufferEvent) {
        Enumeration enumeration = super.getListeners();
        while (enumeration.hasMoreElements()) {
            BufferListener bufferListener = (BufferListener)enumeration.nextElement();
            bufferListener.elementRemoved(bufferEvent);
        }
    }

    public void fireElementRemoved(BufferEventGenerator bufferEventGenerator, Object object) {
        this.fireElementRemoved(BufferEventGeneratorSupport.createElementRemovedEvent(bufferEventGenerator, object));
    }

    public void fireBufferCleared(BufferEvent bufferEvent) {
        Enumeration enumeration = super.getListeners();
        while (enumeration.hasMoreElements()) {
            BufferListener bufferListener = (BufferListener)enumeration.nextElement();
            bufferListener.bufferCleared(bufferEvent);
        }
    }

    public void fireBufferCleared(BufferEventGenerator bufferEventGenerator) {
        this.fireBufferCleared(BufferEventGeneratorSupport.createBufferClearedEvent(bufferEventGenerator));
    }

    public void fireCapacityChanged(BufferEvent bufferEvent) {
        Enumeration enumeration = super.getListeners();
        while (enumeration.hasMoreElements()) {
            BufferListener bufferListener = (BufferListener)enumeration.nextElement();
            bufferListener.capacityChanged(bufferEvent);
        }
    }

    public void fireCapacityChanged(BufferEventGenerator bufferEventGenerator, int n) {
        this.fireCapacityChanged(BufferEventGeneratorSupport.createCapacityChangedEvent(bufferEventGenerator, n));
    }

    public void addBufferListener(BufferListener bufferListener) {
        super.addListener(bufferListener);
    }

    public void removeBufferListener(BufferListener bufferListener) {
        super.removeListener(bufferListener);
    }

    public static BufferEvent createBufferClearedEvent(BufferEventGenerator bufferEventGenerator) {
        return new BufferEvent(bufferEventGenerator);
    }

    public static BufferEvent createElementRemovedEvent(BufferEventGenerator bufferEventGenerator, Object object) {
        return new BufferEvent(bufferEventGenerator, BufferEvent.BUFFER_ELEMENT_REMOVED, object);
    }

    public static BufferEvent createElementAddedEvent(BufferEventGenerator bufferEventGenerator, Object object) {
        return new BufferEvent(bufferEventGenerator, BufferEvent.BUFFER_ELEMENT_ADDED, object);
    }

    public static BufferEvent createCapacityChangedEvent(BufferEventGenerator bufferEventGenerator, int n) {
        return new BufferEvent(bufferEventGenerator, n);
    }

    public String toString() {
        return super.toString();
    }
}

