/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.util.Enumeration;
import java.util.Hashtable;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLMappingLoader;

public class ClassDescriptorResolverImpl
implements ClassDescriptorResolver {
    private static final String DESCRIPTOR_PREFIX = "Descriptor";
    private Hashtable _cache = new Hashtable();
    private boolean _error = false;
    private String _errMessage = null;
    private XMLMappingLoader mappingLoader = null;
    private ClassLoader _loader = null;
    private Introspector _introspector = new Introspector();
    private boolean _useIntrospection = true;

    public ClassDescriptorResolverImpl() {
    }

    public ClassDescriptorResolverImpl(ClassLoader classLoader) {
        this();
        this._loader = classLoader;
    }

    public void associate(Class clazz, XMLClassDescriptor xMLClassDescriptor) {
        this._cache.put(clazz, xMLClassDescriptor);
    }

    private void clearError() {
        this._error = false;
    }

    public boolean error() {
        return this._error;
    }

    public String getErrorMessage() {
        return this._errMessage;
    }

    public XMLMappingLoader getMappingLoader() {
        return this.mappingLoader;
    }

    private Class loadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader != null) {
            return classLoader.loadClass(string);
        }
        if (this._loader != null) {
            return this._loader.loadClass(string);
        }
        return Class.forName(string);
    }

    public XMLClassDescriptor resolve(Class clazz) {
        Object object;
        this.clearError();
        if (clazz == null) {
            return null;
        }
        XMLClassDescriptor xMLClassDescriptor = (XMLClassDescriptor)this._cache.get(clazz);
        if (xMLClassDescriptor != null) {
            return xMLClassDescriptor;
        }
        if (this.mappingLoader != null && (xMLClassDescriptor = (XMLClassDescriptor)this.mappingLoader.getDescriptor(clazz)) != null) {
            this._cache.put(clazz, xMLClassDescriptor);
            return xMLClassDescriptor;
        }
        String string = String.valueOf(clazz.getName()) + DESCRIPTOR_PREFIX;
        try {
            ClassLoader classLoader = clazz.getClassLoader();
            object = this.loadClass(string, classLoader);
            xMLClassDescriptor = (XMLClassDescriptor)((Class)object).newInstance();
            this._cache.put(clazz, xMLClassDescriptor);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            String string2 = "instantiation error for class: " + string;
            string2 = String.valueOf(string2) + "; " + exception.toString();
            this.setError(string2);
            return null;
        }
        if (xMLClassDescriptor == null && this._useIntrospection) {
            try {
                xMLClassDescriptor = this._introspector.generateClassDescriptor(clazz);
                if (xMLClassDescriptor != null) {
                    this._cache.put(clazz, xMLClassDescriptor);
                }
            }
            catch (MarshalException marshalException) {
                object = marshalException.toString();
                this.setError((String)object);
                return null;
            }
        }
        return xMLClassDescriptor;
    }

    public XMLClassDescriptor resolve(String string) {
        return this.resolve(string, null);
    }

    public XMLClassDescriptor resolve(String string, ClassLoader classLoader) {
        XMLClassDescriptor xMLClassDescriptor;
        block9: {
            xMLClassDescriptor = null;
            if (string == null || string.length() == 0) {
                this.clearError();
                this.setError("Cannot resolve a null or zero-length class name.");
                return null;
            }
            Class clazz = null;
            try {
                clazz = this.loadClass(string, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (clazz != null) {
                xMLClassDescriptor = this.resolve(clazz);
            } else {
                this.clearError();
            }
            if (xMLClassDescriptor != null || clazz != null) break block9;
            String string2 = String.valueOf(string) + DESCRIPTOR_PREFIX;
            try {
                Class clazz2 = this.loadClass(string2, classLoader);
                xMLClassDescriptor = (XMLClassDescriptor)clazz2.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return xMLClassDescriptor;
    }

    public XMLClassDescriptor resolveByXMLName(String string, ClassLoader classLoader) {
        if (string == null || string.length() == 0) {
            this.clearError();
            this.setError("Cannot resolve a null or zero-length xml name.");
            return null;
        }
        XMLClassDescriptor xMLClassDescriptor = null;
        Enumeration enumeration = null;
        if (this.mappingLoader != null) {
            enumeration = this.mappingLoader.listDescriptors();
            while (enumeration.hasMoreElements()) {
                xMLClassDescriptor = (XMLClassDescriptor)enumeration.nextElement();
                if (string.equals(xMLClassDescriptor.getXMLName())) {
                    return xMLClassDescriptor;
                }
                xMLClassDescriptor = null;
            }
        }
        enumeration = this._cache.elements();
        while (enumeration.hasMoreElements()) {
            xMLClassDescriptor = (XMLClassDescriptor)enumeration.nextElement();
            if (string.equals(xMLClassDescriptor.getXMLName())) {
                return xMLClassDescriptor;
            }
            xMLClassDescriptor = null;
        }
        return xMLClassDescriptor;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._loader = classLoader;
    }

    private void setError(String string) {
        this._error = true;
        this._errMessage = string;
    }

    public void setIntrospection(boolean bl) {
        this._useIntrospection = bl;
    }

    public void setMappingLoader(XMLMappingLoader xMLMappingLoader) {
        this.mappingLoader = xMLMappingLoader;
    }
}

